/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.documentation;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.registrations.Classes;
import com.github.tukenuke.tuske.documentation.Dependency;
import com.github.tukenuke.tuske.documentation.EventValuesGetter;
import com.github.tukenuke.tuske.util.ReflectionUtils;
import com.github.tukenuke.tuske.util.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.event.Cancellable;

public class SyntaxInfo {
    public String id;
    public String name;
    public String since;
    public String return_type;
    public String dependency;
    public String[] desc;
    public String[] examples;
    public String[] patterns;
    public String[] usage;
    public String[] changers;
    public String[] event_values;
    public Boolean cancellable;

    public SyntaxInfo(SyntaxElementInfo info) {
        Class c = info.c;
        if (c.isAnnotationPresent(NoDoc.class)) {
            return;
        }
        if (c.isAnnotationPresent(Name.class)) {
            this.name = c.getAnnotation(Name.class).value();
        }
        if (this.name == null || this.name.isEmpty()) {
            this.name = c.getSimpleName();
        }
        this.id = c.getSimpleName();
        if (c.isAnnotationPresent(Description.class)) {
            this.desc = this.escapeHtml(c.getAnnotation(Description.class).value());
        }
        if (c.isAnnotationPresent(Examples.class)) {
            this.examples = c.getAnnotation(Examples.class).value();
        }
        this.patterns = this.fixPattern(info.patterns);
        if (c.isAnnotationPresent(Since.class)) {
            this.since = c.getAnnotation(Since.class).value();
        }
        if (c.isAnnotationPresent(Dependency.class)) {
            this.dependency = c.getAnnotation(Dependency.class).value();
        }
    }

    public SyntaxInfo(ExpressionInfo info, Class[] classes) {
        this((SyntaxElementInfo)info);
        ClassInfo ci = Classes.getSuperClassInfo((Class)info.returnType);
        this.return_type = ci != null ? (ci.getDocName() == null || ci.getDocName().isEmpty() ? ci.getCodeName() : ci.getDocName()) : "Object";
        ArrayList<String> array = new ArrayList<String>();
        Expression expr = (Expression)ReflectionUtils.newInstance(info.c);
        try {
            for (Changer.ChangeMode mode : Changer.ChangeMode.values()) {
                if (!Changer.ChangerUtils.acceptsChange((Expression)expr, (Changer.ChangeMode)mode, (Class[])classes)) continue;
                array.add(mode.name().toLowerCase().replace('_', ' '));
            }
            if (array.size() == 0) {
                array.add("none");
            }
        }
        catch (Throwable e) {
            array.add("unknown");
        }
        this.changers = array.toArray(new String[array.size()]);
    }

    public SyntaxInfo(SkriptEventInfo info, EventValuesGetter getter) {
        if (info.getDescription() != null && info.getDescription().equals(SkriptEventInfo.NO_DOC)) {
            return;
        }
        this.name = info.getName();
        this.id = info.getId();
        this.desc = this.escapeHtml(info.getDescription());
        this.examples = info.getExamples();
        this.patterns = this.fixPattern(info.patterns);
        if (this.patterns != null && this.name.startsWith("On ")) {
            for (int x = 0; x < this.patterns.length; ++x) {
                this.patterns[x] = "[on] " + this.patterns[x];
            }
        }
        for (Class c : info.events) {
            if (!Cancellable.class.isAssignableFrom(c)) {
                this.cancellable = Boolean.FALSE;
                break;
            }
            this.cancellable = Boolean.TRUE;
        }
        this.since = info.getSince();
        if (getter != null) {
            Class[][] classes = getter.getEventValues(info.events);
            if (classes == null || classes.length == 0) {
                return;
            }
            String[] time = new String[]{"past event-", "event-", "future event-"};
            ArrayList<String> times = new ArrayList<String>();
            for (int x = 0; x < classes.length; ++x) {
                for (int y = 0; y < classes[x].length; ++y) {
                    ClassInfo ci = Classes.getSuperClassInfo((Class)classes[x][y]);
                    if (ci == null) continue;
                    times.add(time[x] + ci.getCodeName());
                }
            }
            this.event_values = times.toArray(new String[times.size()]);
            if (this.event_values.length == 0) {
                this.event_values = new String[]{"none"};
            }
        }
    }

    public SyntaxInfo(ClassInfo info) {
        if (info.getDocName() != null && info.getDocName().equals(ClassInfo.NO_DOC)) {
            return;
        }
        this.name = info.getDocName();
        this.id = info.getC().getSimpleName();
        this.desc = this.escapeHtml(info.getDescription());
        this.examples = info.getExamples();
        this.usage = this.escapeHtml(info.getUsage());
        this.since = info.getSince();
        if (info.getUserInputPatterns() != null) {
            this.patterns = new String[info.getUserInputPatterns().length];
            int x = 0;
            for (Pattern p : info.getUserInputPatterns()) {
                this.patterns[x++] = p.pattern().replaceAll("\\((.+?)\\)\\?", "[$1]").replaceAll("(.)\\?", "[$1]");
            }
        }
    }

    public SyntaxInfo(JavaFunction info) {
        this.name = info.getName();
        this.id = info.getClass().getSimpleName();
        this.desc = this.escapeHtml(info.getDescription());
        this.examples = info.getExamples();
        StringBuilder sb = new StringBuilder();
        sb.append(info.getName()).append("(");
        if (info.getParameters() != null) {
            int index = 0;
            for (Parameter p : info.getParameters()) {
                if (index++ != 0) {
                    sb.append(", ");
                }
                sb.append(p);
            }
        }
        sb.append(")");
        this.patterns = new String[]{sb.toString()};
        this.since = info.getSince();
        this.return_type = info.getReturnType().getDocName() == null || info.getReturnType().getDocName().isEmpty() ? info.getReturnType().getCodeName() : info.getReturnType().getDocName();
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.addProperty(map, "ID", this.id);
        this.addProperty(map, "Name", this.name);
        this.addArray(map, "Description", this.desc);
        this.addArray(map, "Examples", this.examples);
        this.addProperty(map, "Usage", this.usage);
        this.addArray(map, "Since", this.since);
        this.addProperty(map, "Return type", this.return_type);
        this.addArray(map, "Changers", this.changers);
        this.addArray(map, "Patterns", this.patterns);
        this.addArray(map, "Event values", this.event_values);
        if (this.cancellable != null) {
            map.put("Cancellable", this.cancellable);
        }
        return map;
    }

    private void addProperty(Map<String, Object> map, String property, String ... value) {
        if (!Util.notEmpty(value)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String str : value) {
            if (str == null || str.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(str);
        }
        if (sb.length() > 0) {
            map.put(property, sb.toString());
        }
    }

    private void addArray(Map<String, Object> map, String property, String ... array) {
        if (!Util.notEmpty(array)) {
            return;
        }
        map.put(property, array);
    }

    private String[] fixPattern(String ... syntaxes) {
        if (Util.notEmpty(syntaxes)) {
            syntaxes = (String[])syntaxes.clone();
            for (int x = 0; x < syntaxes.length; ++x) {
                syntaxes[x] = syntaxes[x].replaceAll("\\\\([()])", "$1").replaceAll("\\d+\u00a6", "");
            }
        }
        return syntaxes;
    }

    private String[] escapeHtml(String ... description) {
        if (Util.notEmpty(description)) {
            description = (String[])description.clone();
            for (int x = 0; x < description.length; ++x) {
                description[x] = description[x].replaceAll("<.+?>(.+?)</.+?>", "$1");
            }
        }
        return description;
    }
}

