/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.manager.customenchantment;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Version;
import com.github.tukenuke.tuske.manager.customenchantment.CustomEnchantment;
import com.github.tukenuke.tuske.manager.customenchantment.EnchantConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantManager {
    static final TreeMap<Integer, String> map = new TreeMap();

    public static boolean isCustomByID(String enchant) {
        return CustomEnchantment.getByID(enchant) != null;
    }

    public static boolean isCustomByName(String enchant) {
        return CustomEnchantment.getByName(enchant) != null;
    }

    public static String getCorrectName(String enchant) {
        if ((enchant = ChatColor.stripColor((String)enchant)).contains(" ")) {
            String[] ench = enchant.split(" ");
            try {
                if (EnchantManager.toArabic(ench[ench.length - 1]) >= 0) {
                    enchant = enchant.replace(" " + ench[ench.length - 1], "");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return enchant;
    }

    public int getLevel(CustomEnchantment ce, ItemStack item) {
        return 0;
    }

    public static String getStringEnchant(CustomEnchantment ce, int Level2) {
        if (Skript.getMinecraftVersion().isLargerThan(new Version("1.9")) && Level2 == 1) {
            return ChatColor.GRAY + ce.getName();
        }
        return ChatColor.GRAY + ce.getName() + " " + EnchantManager.toRoman(Level2);
    }

    public static boolean addToItem(ItemStack item, CustomEnchantment enchant, int Level2, boolean NoEnchant) {
        if (enchant.isCompatible(item) && EnchantManager.getNumberOfEnchants(item, enchant) < EnchantManager.getMaxPerItem()) {
            List<String> lore = new ArrayList();
            if (Level2 > enchant.getMaxLevel()) {
                Level2 = enchant.getMaxLevel();
            }
            if (NoEnchant && item.getEnchantments().size() == 0) {
                switch (item.getType()) {
                    case BOOK: {
                        item.setType(Material.ENCHANTED_BOOK);
                    }
                    case ENCHANTED_BOOK: {
                        EnchantmentStorageMeta aa = (EnchantmentStorageMeta)item.getItemMeta();
                        if (aa.getStoredEnchants().size() != 0) break;
                        aa.addStoredEnchant(Enchantment.DURABILITY, 1, false);
                        item.setItemMeta((ItemMeta)aa);
                        break;
                    }
                    default: {
                        item.addEnchantment(Enchantment.DURABILITY, 1);
                    }
                }
            }
            if (item.getItemMeta().getLore() != null) {
                lore = item.getItemMeta().getLore();
            }
            int equals = -1;
            for (int x = 0; x < lore.size(); ++x) {
                String s = EnchantManager.getCorrectName((String)lore.get(x));
                if (!EnchantManager.isCustomByName(s)) continue;
                CustomEnchantment cc = CustomEnchantment.getByName(s);
                if (cc.equals(enchant)) {
                    equals = x;
                }
                if (item.getType() == Material.ENCHANTED_BOOK || !enchant.getConflicts().contains(cc) && !cc.getConflicts().contains(enchant)) continue;
                return false;
            }
            if (equals < 0 || lore.size() == 0) {
                lore.add(EnchantManager.getStringEnchant(enchant, Level2));
            } else {
                lore.set(equals, EnchantManager.getStringEnchant(enchant, Level2));
            }
            ItemMeta meta = item.getItemMeta();
            meta.setLore(lore);
            item.setItemMeta(meta);
            return true;
        }
        return false;
    }

    public static int getMaxPerItem() {
        return EnchantConfig.y.getInt("Config.MaxEnchantmentsPerItem");
    }

    public static boolean removeFromItem(ItemStack item, CustomEnchantment enchant) {
        if (CustomEnchantment.getCustomEnchants(item).containsKey(enchant)) {
            List lore = item.getItemMeta().getLore();
            for (int x = 0; x < lore.size(); ++x) {
                if (!EnchantManager.getCorrectName((String)lore.get(x)).equalsIgnoreCase(enchant.getName())) continue;
                lore.remove(x);
                ItemMeta im = item.getItemMeta();
                im.setLore(lore);
                item.setItemMeta(im);
            }
        }
        return false;
    }

    public static int getStringLevel(String enchant) {
        int max;
        enchant = ChatColor.stripColor((String)enchant);
        String ec = EnchantManager.getCorrectName(enchant);
        if ((enchant = enchant.replaceAll(ec, "").replaceAll(" ", "")).equals("")) {
            return 1;
        }
        int i = EnchantManager.toArabic(enchant);
        return i <= (max = CustomEnchantment.getByName(ec).getMaxLevel()) ? i : max;
    }

    public static int getNumberOfEnchants(ItemStack item, CustomEnchantment enchant) {
        int x = 0;
        Map<CustomEnchantment, Integer> enchs = CustomEnchantment.getCustomEnchants(item);
        if (enchs.containsKey(enchant)) {
            ++x;
        }
        if (EnchantConfig.y.getBoolean("Config.CompatibilityMode")) {
            if (item.getItemMeta().getLore() == null) {
                return 0;
            }
            return item.getItemMeta().getLore().size() - x;
        }
        return enchs.size() - x;
    }

    public static final String toRoman(int number) {
        if (number <= 0) {
            return "";
        }
        int l = map.floorKey(number);
        if (number == l) {
            return map.get(number);
        }
        return map.get(l) + EnchantManager.toRoman(number - l);
    }

    public static final int toArabic(String number) {
        for (Integer key : map.keySet()) {
            String[] s = number.split("");
            if (s.length > 1) {
                if (map.get(key).equals(s[0]) && key >= EnchantManager.toArabic(s[1])) {
                    return key + EnchantManager.toArabic(number.replaceFirst(map.get(key), ""));
                }
                if (map.get(key).equals(s[0])) {
                    return EnchantManager.toArabic(number.replaceFirst(map.get(key), "")) - key;
                }
            }
            if (!map.get(key).equals(number)) continue;
            return key;
        }
        return 0;
    }

    static {
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
    }
}

