/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.documentation;

import com.github.tukenuke.tuske.documentation.AddonInfo;
import com.github.tukenuke.tuske.documentation.FileType;
import com.github.tukenuke.tuske.documentation.SyntaxInfo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlFile
extends FileType {
    public YamlFile() {
        super("yml");
    }

    @Override
    public void write(BufferedWriter writer, AddonInfo addon) throws IOException {
        YamlConfiguration yaml = new YamlConfiguration();
        this.addSection(yaml, "Events", addon.getEvents());
        this.addSection(yaml, "Conditions", addon.getConditions());
        this.addSection(yaml, "Effects", addon.getEffects());
        this.addSection(yaml, "Expressions", addon.getExpressions());
        this.addSection(yaml, "Types", addon.getTypes());
        this.addSection(yaml, "Functions", addon.getFunctions());
        writer.write(yaml.saveToString());
    }

    public void addSection(YamlConfiguration yaml, String section, List<SyntaxInfo> list) {
        for (SyntaxInfo info : list) {
            for (Map.Entry<String, Object> entry : info.toMap().entrySet()) {
                if (entry.getKey().equalsIgnoreCase("name")) continue;
                String[] obj = entry.getValue();
                if (entry.getKey().equalsIgnoreCase("Patterns") && obj instanceof String) {
                    obj = ((String)obj).split("\n");
                }
                yaml.set(section + "." + info.name + "." + entry.getKey(), (Object)obj);
            }
        }
    }
}

