/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.documentation;

import com.github.tukenuke.tuske.documentation.AddonInfo;
import com.github.tukenuke.tuske.documentation.FileType;
import com.github.tukenuke.tuske.documentation.SyntaxInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JsonFile
extends FileType {
    private Gson gson;

    public JsonFile(boolean raw) {
        super("json");
        GsonBuilder gson = new GsonBuilder().disableHtmlEscaping();
        if (!raw) {
            gson.enableComplexMapKeySerialization().setPrettyPrinting();
        }
        this.gson = gson.create();
    }

    @Override
    public void write(BufferedWriter writer, AddonInfo addon) throws IOException {
        JsonObject json = new JsonObject();
        this.addSection(json, "events", addon.getEvents());
        this.addSection(json, "conditions", addon.getConditions());
        this.addSection(json, "effects", addon.getEffects());
        this.addSection(json, "expressions", addon.getExpressions());
        this.addSection(json, "types", addon.getTypes());
        this.addSection(json, "functions", addon.getFunctions());
        this.gson.toJson((JsonElement)json, (Appendable)writer);
    }

    public void addSection(JsonObject json, String property, List<SyntaxInfo> list) {
        JsonArray array = new JsonArray();
        for (SyntaxInfo syntax : list) {
            JsonObject jsonSyntax = this.getJsonSyntax(syntax);
            if (!jsonSyntax.has("patterns")) continue;
            array.add((JsonElement)this.getJsonSyntax(syntax));
        }
        if (array.size() > 0) {
            json.add(property, (JsonElement)array);
        }
    }

    public JsonObject getJsonSyntax(SyntaxInfo info) {
        JsonObject syntax = new JsonObject();
        for (Map.Entry<String, Object> entry : info.toMap().entrySet()) {
            String property = entry.getKey().toLowerCase().replace('_', ' ');
            if (entry.getValue() instanceof String) {
                syntax.addProperty(property, (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                syntax.addProperty(property, (Boolean)entry.getValue());
                continue;
            }
            JsonArray json = new JsonArray();
            for (String str : (String[])entry.getValue()) {
                json.add((JsonElement)new JsonPrimitive(str));
            }
            syntax.add(property, (JsonElement)json);
        }
        return syntax;
    }
}

