/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.github.tukenuke.tuske.util.CommandUtils;
import com.github.tukenuke.tuske.util.ReflectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.bukkit.command.Command;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.event.Event;

@Name(value="Command Info")
@Description(value={"Get informations about a command."})
@Examples(value={"if co"})
@Since(value="1.6.9.6, 1.6.9.7")
public class ExprCommandInfo
extends SimpleExpression<String> {
    private Expression<String> cmd;
    private int id = -1;
    private String expr;

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return this.id != 6;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.id = arg1 / 2;
        this.cmd = arg[0];
        this.expr = arg3.expr.toLowerCase().split("command")[0] + "command";
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.expr;
    }

    @Nullable
    protected String[] get(Event e) {
        String cmd = (String)this.cmd.getSingle(e);
        if (cmd != null) {
            if ((cmd = cmd.toLowerCase()).startsWith("/")) {
                cmd = cmd.substring(1);
            }
            if (this.id < 7) {
                Command c = CommandUtils.getCommand(cmd);
                if (c != null) {
                    switch (this.id) {
                        case 0: {
                            return new String[]{c.getDescription() != null && !c.getDescription().equalsIgnoreCase("") ? c.getDescription() : null};
                        }
                        case 1: {
                            return new String[]{c.getName()};
                        }
                        case 2: {
                            return new String[]{c.getPermission() != null && !c.getPermission().equalsIgnoreCase("") ? c.getPermission() : null};
                        }
                        case 3: {
                            return new String[]{c.getPermissionMessage()};
                        }
                        case 4: {
                            if (c instanceof PluginCommand) {
                                return new String[]{((PluginCommand)c).getPlugin().getName()};
                            }
                            if (c instanceof BukkitCommand) {
                                return new String[]{"Bukkit"};
                            }
                            if (c.getClass().getPackage().getName().startsWith("org.spigot")) {
                                return new String[]{"Spigot"};
                            }
                            if (!c.getPermission().startsWith("minecraft")) break;
                            return new String[]{"Minecraft"};
                        }
                        case 5: {
                            return new String[]{c.getUsage() != null ? c.getUsage().replaceAll("^/?<command>", "/" + c.getName()) : null};
                        }
                        case 6: {
                            return c.getAliases().toArray(new String[c.getAliases().size()]);
                        }
                    }
                }
            } else {
                HashMap cmds = (HashMap)ReflectionUtils.getField(Commands.class, null, "commands");
                if (cmds == null) {
                    cmds = new HashMap();
                }
                if (cmds.containsKey(cmd)) {
                    String result = ((ScriptCommand)cmds.get(cmd)).getScript().getAbsolutePath();
                    if (result.toLowerCase().contains("scripts")) {
                        result = result.split("scripts")[1].substring(1);
                    }
                    return new String[]{result};
                }
            }
        }
        return null;
    }

    static {
        Registry.newSimple(ExprCommandInfo.class, "[the] description of command %string%", "command %string%'[s] description", "[the] main [command] of command %string%", "command %string%'[s] main [command]", "[the] permission of command %string%", "command %string%'[s] permission", "[the] permission message of command %string%", "command %string%'[s] permission message", "[the] plugin [owner] of command %string%", "command %string%'[s] plugin [owner]", "[the] usage of command %string%", "command %string%'[s] usage", "[the] aliases of command %string%", "command %string%'[s] aliases", "[the] file [location] of command %string%", "command %string%'[s] file location");
    }
}

