/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions.recipe;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.github.tukenuke.tuske.TuSKe;
import com.github.tukenuke.tuske.util.Registry;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

@Name(value="Recipe Owner")
@Description(value={"Starting from minecraft 1.12, recipes have now the register plugin. If it is a minecraft recipe, it will return as `Minecraft`, if it is an old recipe plugin, it will return as `Bukkit` and everything else will return the plugin's name. **Only for Shaped and Shapeless recipes**"})
@Examples(value={"loop recipes of held item:", "\tif recipe owner of loop-recipe is \"Minecraft\":", "\t\tsend \"That's a vanilla recipe!\""})
@Since(value="1.8")
public class ExprRecipeOwner
extends SimplePropertyExpression<Recipe, String> {
    protected String getPropertyName() {
        return "recipe owner";
    }

    public String convert(Recipe recipe) {
        if (recipe instanceof Keyed) {
            String plugin;
            switch (plugin = ((Keyed)recipe).getKey().getNamespace()) {
                case "bukkit": {
                    return "Bukkit";
                }
                case "minecraft": {
                    return "Minecraft";
                }
                case "tuske": {
                    return TuSKe.getInstance().getName();
                }
            }
            for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
                if (!p.getName().equalsIgnoreCase(plugin)) continue;
                return p.getName();
            }
        }
        return null;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        Registry.newProperty(ExprRecipeOwner.class, "recipe owner", "recipes");
    }
}

