/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;

public class ExprDroppedExp
extends SimpleExpression<Experience> {
    public Class<? extends Experience> getReturnType() {
        return Experience.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        return ScriptLoader.isCurrentEvent((Class[])new Class[]{BlockBreakEvent.class, EntityDeathEvent.class, FurnaceExtractEvent.class});
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "dropped experience";
    }

    @Nullable
    protected Experience[] get(Event e) {
        if (e instanceof BlockBreakEvent) {
            return new Experience[]{new Experience(((BlockBreakEvent)e).getExpToDrop())};
        }
        if (e instanceof EntityDeathEvent) {
            return new Experience[]{new Experience(((EntityDeathEvent)e).getDroppedExp())};
        }
        if (e instanceof FurnaceExtractEvent) {
            return new Experience[]{new Experience(((FurnaceExtractEvent)e).getExpToDrop())};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        int b = 0;
        if (delta != null) {
            b = delta[0] instanceof Experience ? ((Experience)delta[0]).getXP() : ((Number)delta[0]).intValue();
        } else if (mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET) {
            return;
        }
        int a = 0;
        if (e instanceof BlockBreakEvent) {
            a = ((BlockBreakEvent)e).getExpToDrop();
        } else if (e instanceof EntityDeathEvent) {
            a = ((EntityDeathEvent)e).getDroppedExp();
        } else if (e instanceof FurnaceExtractEvent) {
            a = ((FurnaceExtractEvent)e).getExpToDrop();
        }
        switch (mode) {
            case ADD: {
                a += b;
                break;
            }
            case REMOVE: {
                a -= b;
                break;
            }
            default: {
                a = b;
            }
        }
        if (e instanceof BlockBreakEvent) {
            ((BlockBreakEvent)e).setExpToDrop(a);
        } else if (e instanceof EntityDeathEvent) {
            ((EntityDeathEvent)e).setDroppedExp(a);
        } else if (e instanceof FurnaceExtractEvent) {
            ((FurnaceExtractEvent)e).setExpToDrop(a);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Experience.class, Number.class});
        }
        return null;
    }

    static {
        Registry.newSimple(ExprDroppedExp.class, "[the] dropped [e]xp[erience] [orb[s]]");
    }
}

