/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.command.Commands;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.github.tukenuke.tuske.util.CommandUtils;
import com.github.tukenuke.tuske.util.ReflectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="All commands")
@Description(value={"Returns a list containing all registered commands or scripts commands only."})
@Examples(value={"send \"Current amount of script commands: %size of all script commands%", "send \"Current amount of non script commands: %size of commansd - size of script commands%", "send \"Total: %size of all commands%\""})
@Since(value="1.6.9.7")
public class ExprAllCommand
extends SimpleExpression<String> {
    private boolean scriptsOnly = false;

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.scriptsOnly = arg3.expr.toLowerCase().contains("script");
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.scriptsOnly ? "all scripts command" : "all commands";
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.scriptsOnly) {
            HashMap cmds = (HashMap)ReflectionUtils.getField(Commands.class, null, "commands");
            if (cmds == null) {
                cmds = new HashMap();
            }
            return cmds.keySet().toArray(new String[cmds.size()]);
        }
        return CommandUtils.getCommandList();
    }

    static {
        Registry.newSimple(ExprAllCommand.class, "[all] [registered] [script] commands");
    }
}

