/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.effects;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.github.tukenuke.tuske.util.CommandUtils;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Command with Permission")
@Description(value={"Make the player execute a command with a temporary permission, when the player finishes executing the command, the permission is removed."})
@Examples(value={"make all players execute command \"example\" with permissions \"permission.one\" and \"permission.two\""})
@Since(value="1.6.9.7")
public class EffExecutePermission
extends Effect {
    private Expression<Player> p;
    private Expression<String> cmd;
    private Expression<String> perm;

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        if (arg1 == 0) {
            this.cmd = arg[0];
            this.p = arg[1];
        } else {
            this.p = arg[0];
            this.cmd = arg[1];
        }
        this.perm = arg[2];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "execute " + this.p + " command " + this.cmd + " with permission " + this.perm;
    }

    protected void execute(Event e) {
        Player[] p = (Player[])this.p.getArray(e);
        String[] cmd = (String[])this.cmd.getArray(e);
        String perm = (String)this.perm.getSingle(e);
        if (p != null && cmd != null && perm != null) {
            for (Player player : p) {
                for (String command : cmd) {
                    CommandUtils.runCommand((CommandSender)player, command, perm);
                }
            }
        }
    }

    static {
        Registry.newEffect(EffExecutePermission.class, "[execute] [the] command %strings% by %players% with perm[ission][s] %strings%", "[execute] [the] %players% command %strings% with perm[ission][s] %strings%", "(let|make) %players% execute [[the] command] %strings% with perm[ission][s] %strings%");
    }
}

