/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.documentation;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import com.github.tukenuke.tuske.documentation.AddonInfo;
import com.github.tukenuke.tuske.documentation.EventValuesGetter;
import com.github.tukenuke.tuske.documentation.FileType;
import com.github.tukenuke.tuske.documentation.SyntaxInfo;
import com.github.tukenuke.tuske.util.EffectSection;
import com.github.tukenuke.tuske.util.ReflectionUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Documentation
implements Runnable {
    private Map<String, AddonInfo> addons = new HashMap<String, AddonInfo>();
    private JavaPlugin instance;
    private FileType fileType;

    public Documentation(JavaPlugin plugin, FileType file) {
        this.instance = plugin;
        this.fileType = file;
    }

    public void load() {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.instance, (Runnable)this, 100L);
    }

    @Override
    public void run() {
        File docsDir;
        if (Skript.isAcceptRegistrations()) {
            return;
        }
        this.instance.getLogger().info("Generating documentation of Skript & Addons.");
        this.addons.put(Skript.class.getPackage().getName(), new AddonInfo("Skript"));
        for (Object addon : Skript.getAddons()) {
            this.addons.put(((SkriptAddon)addon).plugin.getClass().getPackage().getName(), new AddonInfo(addon.getName()));
        }
        EventValuesGetter getter = new EventValuesGetter();
        for (SkriptEventInfo info2 : Skript.getEvents()) {
            this.addSyntax(this.getAddon(info2.c).getEvents(), new SyntaxInfo(info2, getter));
        }
        for (SkriptEventInfo info2 : Skript.getConditions()) {
            if (EffectSection.class.isAssignableFrom(info2.c)) {
                this.addSyntax(this.getAddon(info2.c).getEffects(), new SyntaxInfo((SyntaxElementInfo)info2));
                continue;
            }
            this.addSyntax(this.getAddon(info2.c).getConditions(), new SyntaxInfo((SyntaxElementInfo)info2));
        }
        for (SkriptEventInfo info2 : Skript.getEffects()) {
            this.addSyntax(this.getAddon(info2.c).getEffects(), new SyntaxInfo((SyntaxElementInfo)info2));
        }
        Class[] types = new Class[Classes.getClassInfos().size()];
        int x = 0;
        for (Object info3 : Classes.getClassInfos()) {
            types[x++] = info3.getC();
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        Skript.getExpressions().forEachRemaining(info -> this.addSyntax(this.getAddon(info.c).getExpressions(), new SyntaxInfo((ExpressionInfo)info, types)));
        log.clear();
        log.stop();
        for (Object info4 : Classes.getClassInfos()) {
            this.addSyntax(this.getAddon((ClassInfo)info4).getTypes(), new SyntaxInfo((ClassInfo)info4));
        }
        Collection functions = (Collection)ReflectionUtils.invokeMethod(Functions.class, "getJavaFunctions", null, new Object[0]);
        if (functions != null) {
            for (JavaFunction info5 : functions) {
                this.addSyntax(this.getAddon(info5.getClass()).getFunctions(), new SyntaxInfo(info5));
            }
        }
        if ((docsDir = new File(this.instance.getDataFolder(), "documentation/")).exists()) {
            File[] files = docsDir.listFiles();
            if (files != null) {
                for (File f : files) {
                    f.delete();
                }
            }
        } else {
            docsDir.mkdirs();
        }
        for (AddonInfo addon : this.addons.values()) {
            addon.sortLists();
            File file = new File(docsDir, addon.getName() + "." + this.fileType.getExtension());
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                Throwable throwable = null;
                try {
                    this.fileType.write(writer, addon);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
        this.instance.getLogger().info("Documentation was generated successfully.");
    }

    private void addSyntax(List<SyntaxInfo> list, SyntaxInfo syntax) {
        if (syntax.name == null || syntax.name.isEmpty()) {
            return;
        }
        if (syntax.patterns == null || syntax.patterns.length == 0) {
            return;
        }
        list.add(syntax);
    }

    public AddonInfo getAddon(ClassInfo info) {
        AddonInfo addon = info.getParser() != null ? this.getAddon(info.getParser().getClass()) : (info.getSerializer() != null ? this.getAddon(info.getSerializer().getClass()) : (info.getChanger() != null ? this.getAddon(info.getChanger().getClass()) : this.getAddon(info.getClass())));
        return addon;
    }

    public AddonInfo getAddon(Class<?> c) {
        String name = c.getPackage().getName();
        for (Map.Entry<String, AddonInfo> entry : this.addons.entrySet()) {
            if (!name.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return this.addons.get(Skript.class.getPackage().getName());
    }
}

