/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.bukkit.plugin.java.JavaPlugin;

public class GitHubUpdater {
    private final JavaPlugin PLUGIN;
    private final File PLUGIN_JAR;
    private final String URL;
    private boolean DOWNLOAD_BETA;
    private String UPDATE_TITLE = null;
    private String UPDATE_VERSION = null;
    private String UPDATE_DOWNLOAD_URL = null;
    private String UPDATE_URL = null;

    public GitHubUpdater(JavaPlugin instance, File pluginFile, String gitHubUrl, boolean acceptBetaReleases) {
        if (instance == null) {
            throw new IllegalStateException("The instance of your plugin can not be null.");
        }
        if (pluginFile == null) {
            throw new IllegalStateException("The jar file of your plugin can not be null. Get it with JavaPlugin#getFile()");
        }
        if (gitHubUrl == null) {
            throw new IllegalStateException("The repository can not be null. It should be like: <User>/<Repository>");
        }
        this.PLUGIN = instance;
        this.PLUGIN_JAR = pluginFile;
        this.URL = gitHubUrl;
        this.DOWNLOAD_BETA = acceptBetaReleases;
    }

    public void acceptBetaReleases(boolean value) {
        this.DOWNLOAD_BETA = value;
    }

    public void checkForUpdate(boolean showMessageError) throws IllegalArgumentException {
        Thread updater = new Thread(() -> {
            HttpURLConnection github = null;
            try {
                github = (HttpURLConnection)new URL("https://api.github.com/repos/" + this.URL + "/releases").openConnection();
                github.setRequestProperty("User-Agent", this.PLUGIN.getName());
                github.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                github.setRequestProperty("Connection", "keep-alive");
                github.setRequestProperty("Accept", "application/vnd.github.v3+json");
                BufferedReader br = new BufferedReader(new InputStreamReader(github.getInputStream()));
                JsonArray releases = (JsonArray)new JsonParser().parse((Reader)br);
                br.close();
                this.UPDATE_DOWNLOAD_URL = null;
                this.UPDATE_TITLE = null;
                this.UPDATE_URL = null;
                this.UPDATE_VERSION = null;
                for (JsonElement release : releases) {
                    if (!(release instanceof JsonObject) || this.UPDATE_VERSION != null || this.UPDATE_TITLE != null || ((JsonObject)release).get("prerelease").getAsBoolean() && !this.DOWNLOAD_BETA) continue;
                    this.UPDATE_VERSION = ((JsonObject)release).get("tag_name").getAsString();
                    if (this.UPDATE_VERSION.startsWith("v")) {
                        this.UPDATE_VERSION = this.UPDATE_VERSION.substring(1);
                    }
                    this.UPDATE_TITLE = ((JsonObject)release).get("name").getAsString();
                    this.UPDATE_URL = ((JsonObject)release).get("html_url").getAsString();
                    JsonArray assets = ((JsonObject)release).get("assets").getAsJsonArray();
                    for (JsonElement asset : assets) {
                        if (!(asset instanceof JsonObject)) continue;
                        this.UPDATE_DOWNLOAD_URL = ((JsonObject)asset).get("browser_download_url").getAsString();
                    }
                }
                return;
            }
            catch (MalformedURLException e) {
                if (showMessageError) {
                    this.PLUGIN.getLogger().severe("The updater couldn't get the link of the latest version.\n" + e.getMessage());
                }
            }
            catch (Exception e) {
                if (showMessageError) {
                    this.PLUGIN.getLogger().warning("An unexpected error occurred when trying to check for latest update.");
                }
            }
            finally {
                if (github != null) {
                    github.disconnect();
                }
            }
            this.UPDATE_VERSION = null;
            this.UPDATE_TITLE = null;
        }, this.PLUGIN.getName() + "'s Updater");
        updater.run();
    }

    public void updatePlugin() {
        if (this.hasDownloadReady(true)) {
            File jarNew = new File(this.PLUGIN.getDataFolder(), this.PLUGIN.getName() + ".jar");
            File jarOld = new File("plugins" + File.separator, this.PLUGIN_JAR.getName());
            try {
                jarOld.delete();
                FileUtils.copyFileToDirectory((File)jarNew, (File)new File("plugins" + File.separator));
                jarNew.delete();
            }
            catch (IOException e) {
                this.PLUGIN.getLogger().severe("An unexpected error occurred when trying to update the plugin.\n" + e.getMessage());
            }
        }
    }

    public String getURL() {
        return this.UPDATE_URL;
    }

    public String getUpdateTitle() {
        return this.UPDATE_TITLE;
    }

    public String getLatestVersion() {
        return this.UPDATE_VERSION;
    }

    public String getDownloadURL() {
        return this.UPDATE_DOWNLOAD_URL;
    }

    public boolean isLatestVersion() {
        String v1 = this.PLUGIN.getDescription().getVersion();
        String v2 = this.UPDATE_VERSION;
        if (v1.startsWith("v")) {
            v1 = v1.substring(1);
        }
        if (v2.startsWith("v")) {
            v2 = v2.substring(1);
        }
        return v1.equals(v2);
    }

    public boolean hasDownloadReady(boolean ignoreVersion) {
        return new File(this.PLUGIN.getDataFolder(), this.PLUGIN.getName() + ".jar").exists() && (ignoreVersion || !this.isLatestVersion());
    }

    public void downloadLatest() {
        Thread downloadThread = new Thread(() -> {
            HttpURLConnection download = null;
            try {
                download = (HttpURLConnection)new URL(this.UPDATE_DOWNLOAD_URL).openConnection();
                download.setRequestProperty("User-Agent", "Mozilla/5.0");
                File f = new File(this.PLUGIN.getDataFolder(), this.PLUGIN.getName() + ".jar");
                if (f.exists()) {
                    f.delete();
                }
                FileUtils.copyInputStreamToFile((InputStream)download.getInputStream(), (File)f);
            }
            catch (Exception exception) {
            }
            finally {
                if (download != null) {
                    download.disconnect();
                }
            }
        });
        downloadThread.start();
    }
}

