/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.listeners;

import com.github.tukenuke.tuske.TuSKe;
import com.github.tukenuke.tuske.manager.gui.v2.SkriptGUIEvent;
import com.github.tukenuke.tuske.util.InventoryUtils;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public abstract class GUIListener {
    private Inventory gui;
    private boolean isStarted = false;

    public GUIListener(Inventory gui) {
        this.gui = gui;
    }

    public abstract void onClick(InventoryClickEvent var1, int var2);

    public abstract void onClose(InventoryCloseEvent var1);

    public abstract void onDrag(InventoryDragEvent var1, int var2);

    public void onEvent(Event event) {
        block11: {
            block12: {
                block10: {
                    Inventory click;
                    if (!(event instanceof InventoryClickEvent) || ((InventoryClickEvent)event).isCancelled()) break block10;
                    InventoryClickEvent e = (InventoryClickEvent)event;
                    if (!this.isAllowedType(e.getClick()) || (click = InventoryUtils.getClickedInventory(e)) == null) break block11;
                    Inventory op = InventoryUtils.getOpositiveInventory(e.getView(), click);
                    if (op == null || !click.equals(this.gui) && !op.equals(this.gui)) {
                        return;
                    }
                    int slot = e.getSlot();
                    switch (e.getAction()) {
                        case MOVE_TO_OTHER_INVENTORY: {
                            if (!this.gui.equals(op)) break;
                            click = op;
                            slot = InventoryUtils.getSlotTo(op, e.getCurrentItem());
                            break;
                        }
                        case COLLECT_TO_CURSOR: {
                            click = this.gui;
                            slot = InventoryUtils.getSlotTo(click, e.getCursor());
                            break;
                        }
                        case HOTBAR_SWAP: 
                        case HOTBAR_MOVE_AND_READD: {
                            if (!this.gui.getType().equals((Object)InventoryType.PLAYER)) break;
                            slot = e.getHotbarButton();
                            click = this.gui;
                        }
                    }
                    if (click.equals(this.gui)) {
                        this.onClick(e, slot);
                    }
                    break block11;
                }
                if (!(event instanceof InventoryCloseEvent)) break block12;
                InventoryCloseEvent e = (InventoryCloseEvent)event;
                if (!e.getInventory().equals(this.gui)) break block11;
                if (e.getViewers().size() == 1) {
                    Bukkit.getScheduler().runTask((Plugin)TuSKe.getInstance(), this::stop);
                }
                this.onClose(e);
                break block11;
            }
            if (event instanceof InventoryDragEvent && ((InventoryDragEvent)event).getInventory().equals(this.gui)) {
                Iterator iterator = ((InventoryDragEvent)event).getRawSlots().iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    if (slot >= ((InventoryDragEvent)event).getInventory().getSize()) continue;
                    slot = ((InventoryDragEvent)event).getView().convertSlot(slot);
                    this.onDrag((InventoryDragEvent)event, slot);
                    if (!((InventoryDragEvent)event).isCancelled()) continue;
                    break;
                }
            }
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void stop() {
        if (this.isStarted() && this.gui.getViewers().size() == 0) {
            SkriptGUIEvent.getInstance().unregister(this);
            this.isStarted = false;
        }
    }

    public void start() {
        if (!this.isStarted()) {
            this.isStarted = true;
            SkriptGUIEvent.getInstance().register(this);
        }
    }

    public void setInventory(Inventory inv) {
        this.gui = inv;
    }

    private boolean isAllowedType(ClickType ct) {
        if (ct != null) {
            switch (ct) {
                case UNKNOWN: 
                case WINDOW_BORDER_RIGHT: 
                case WINDOW_BORDER_LEFT: 
                case CREATIVE: {
                    return false;
                }
            }
        }
        return true;
    }

    public void finalize() {
        this.gui.clear();
    }
}

