/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.hooks.legendchat;

import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.api.events.ChatMessageEvent;
import br.com.devpaulo.legendchat.api.events.PrivateMessageEvent;
import br.com.devpaulo.legendchat.channels.ChannelManager;
import br.com.devpaulo.legendchat.channels.types.Channel;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import com.github.tukenuke.tuske.TuSKe;
import com.github.tukenuke.tuske.hooks.legendchat.LegendchatConfig;
import com.github.tukenuke.tuske.util.SimpleType;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LegendchatRegister {
    public static LegendchatConfig config;

    public LegendchatRegister(SkriptAddon tuske) {
        this.types();
        this.eventValues();
        this.comparators();
        try {
            config = new LegendchatConfig((TuSKe)tuske.plugin);
            tuske.loadClasses(this.getClass().getPackage().getName(), new String[]{"events", "conditions", "effects", "expressions"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void types() {
        new SimpleType<Channel>(Channel.class, "channel"){

            @Override
            @Nullable
            public Channel parse(String s, ParseContext context) {
                ChannelManager cm = Legendchat.getChannelManager();
                if (cm.existsChannel(s.toLowerCase())) {
                    return cm.getChannelByName(s.toLowerCase());
                }
                return null;
            }

            @Override
            public String toString(Channel c, int flags) {
                return c.getName().toLowerCase();
            }

            @Override
            public String toVariableNameString(Channel c) {
                return c.toString().toLowerCase();
            }
        };
    }

    private void eventValues() {
        EventValues.registerEventValue(ChatMessageEvent.class, Player.class, (Getter)new Getter<Player, ChatMessageEvent>(){

            public Player get(ChatMessageEvent event) {
                return event.getSender();
            }
        }, (int)0);
        EventValues.registerEventValue(PrivateMessageEvent.class, CommandSender.class, (Getter)new Getter<CommandSender, PrivateMessageEvent>(){

            public CommandSender get(PrivateMessageEvent event) {
                return event.getSender();
            }
        }, (int)0);
    }

    private void comparators() {
        Comparators.registerComparator(Channel.class, Channel.class, (Comparator)new Comparator<Channel, Channel>(){

            public Comparator.Relation compare(Channel arg0, Channel arg1) {
                return Comparator.Relation.get((boolean)arg0.equals(arg1));
            }

            public boolean supportsOrdering() {
                return true;
            }
        });
    }
}

