/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.hooks.landlord.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import com.jcdesimp.landlord.persistantData.Friend;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

public class ExprLandFriends
extends SimpleExpression<OfflinePlayer> {
    private Expression<LowOwnedLand> ol;

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.ol = arg[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "land friends of " + this.ol;
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        LowOwnedLand ol = (LowOwnedLand)this.ol.getSingle(e);
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>();
        if (ol != null) {
            for (Friend f : ol.getFriends()) {
                players.add(Bukkit.getOfflinePlayer((String)f.getName()));
            }
            return players.toArray(new OfflinePlayer[players.size()]);
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        LowOwnedLand ol = (LowOwnedLand)this.ol.getSingle(e);
        OfflinePlayer[] ob = null;
        if (mode != Changer.ChangeMode.RESET || mode != Changer.ChangeMode.DELETE) {
            ob = (OfflinePlayer[])delta;
        }
        for (Friend f : ol.getFriends()) {
            Bukkit.broadcastMessage((String)f.getName());
        }
        if (ol != null) {
            switch (mode) {
                case RESET: 
                case DELETE: {
                    for (Friend f : ol.getFriends()) {
                        ol.removeFriend(f);
                    }
                    break;
                }
                case SET: {
                    for (Friend f : ol.getFriends()) {
                        ol.removeFriend(f);
                    }
                }
                case ADD: {
                    if (ob == null) break;
                    for (OfflinePlayer offlinePlayer : ob) {
                        ol.addFriend(Friend.friendFromOfflinePlayer((String)offlinePlayer.getName()));
                    }
                    break;
                }
                case REMOVE: {
                    for (OfflinePlayer offlinePlayer : ob) {
                        ol.removeFriend(Friend.friendFromOfflinePlayer((String)offlinePlayer.getName()));
                    }
                    break;
                }
            }
            Bukkit.broadcastMessage((String)"Hei");
            for (Friend f : ol.getFriends()) {
                Bukkit.broadcastMessage((String)f.getName());
            }
            ol.save();
            for (Friend f : ol.getFriends()) {
                Bukkit.broadcastMessage((String)(f.getName() + " dps"));
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer[].class});
        }
        return null;
    }

    static {
        Registry.newProperty(ExprLandFriends.class, "land[lord] friends", "landclaim");
    }
}

