/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;

public class ExprDraggedItem
extends SimpleExpression<ItemStack> {
    private boolean isOld;

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        if (!ScriptLoader.isCurrentEvent(InventoryDragEvent.class)) {
            Skript.error((String)("The expression '" + arg3.expr + "' can only be used in Inventory Drag event."));
            return false;
        }
        this.isOld = arg3.expr.toLowerCase().contains("old");
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return null;
    }

    @Nullable
    protected ItemStack[] get(Event e) {
        if (this.isOld) {
            return new ItemStack[]{((InventoryDragEvent)e).getOldCursor()};
        }
        return new ItemStack[]{((InventoryDragEvent)e).getCursor()};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (!this.isOld) {
            ItemStack i = new ItemStack(Material.AIR);
            InventoryDragEvent ev = (InventoryDragEvent)e;
            if (delta == null && mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET) {
                return;
            }
            if (mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET) {
                i = (ItemStack)delta[0];
            }
            switch (mode) {
                case ADD: {
                    if (i.isSimilar(ev.getCursor())) {
                        i.setAmount(ev.getCursor().getAmount() + i.getAmount());
                        break;
                    }
                    return;
                }
                case REMOVE: {
                    if (i.isSimilar(ev.getCursor())) {
                        i.setAmount(ev.getCursor().getAmount() - i.getAmount());
                        break;
                    }
                    return;
                }
            }
            ev.setCursor(i);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.isOld) {
            Skript.error((String)"Only the item after the event can is settable.");
            return null;
        }
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ItemStack.class});
        }
        return null;
    }

    static {
        Registry.newSimple(ExprDraggedItem.class, "[event-][old(-| )]dragged(-| )item");
    }
}

