/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions.gui;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.github.tukenuke.tuske.manager.gui.v2.GUIHandler;
import com.github.tukenuke.tuske.manager.gui.v2.GUIInventory;
import com.github.tukenuke.tuske.util.Registry;
import org.bukkit.event.Event;

@Name(value="Last GUI/GUI from id")
@Description(value={"It is used to return the last created gui or a gui from a string id."})
@Examples(value={"on skript load:", "\tcreate new gui with id \"HUB\" with virtual chest:", "\t\tmake gui slot 1 with diamond named \"Server 1\":", "\t\t\texecute player command \"/server server1\"", "\t\tmake gui slot 2 with paper named \"Server 2\":", "\t\t\texecute player command \"/server server2\"", " ", "command /hub [<text>]:", "\ttrigger:", "\t\topen gui \"HUB\" to player"})
@Since(value="1.7.5")
public class ExprGUI
extends SimpleExpression<GUIInventory> {
    private Expression<String> id;

    protected GUIInventory[] get(Event e) {
        if (this.id != null) {
            return new GUIInventory[]{GUIHandler.getInstance().getGUI((String)this.id.getSingle(e))};
        }
        return new GUIInventory[]{GUIHandler.getInstance().getGUIEvent(e)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends GUIInventory> getReturnType() {
        return GUIInventory.class;
    }

    public String toString(Event event, boolean b) {
        return this.id == null ? "last gui" : "gui " + this.id.toString(event, b);
    }

    public boolean init(Expression<?>[] arg, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (i > 0) {
            this.id = arg[0];
        }
        return true;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        GUIInventory gui;
        String id = (String)this.id.getSingle(e);
        if (id != null && (gui = GUIHandler.getInstance().removeGUI(id)) != null) {
            gui.clear();
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE) {
            return new Class[]{Object.class};
        }
        return null;
    }

    static {
        Registry.newSimple(ExprGUI.class, "last[ly] [created] gui", "gui [with id] %string%");
    }
}

