/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions.customenchantments;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.tukenuke.tuske.manager.customenchantment.CEnchant;
import com.github.tukenuke.tuske.manager.customenchantment.CustomEnchantment;
import com.github.tukenuke.tuske.manager.customenchantment.EnchantConfig;
import com.github.tukenuke.tuske.util.Registry;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

public class ExprCEConflicts
extends SimpleExpression<CEnchant> {
    private Expression<CEnchant> ce;

    public Class<? extends CEnchant> getReturnType() {
        return CEnchant.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.ce = arg[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "conflicts of " + (this.ce != null ? this.ce : "custom enchantment");
    }

    @Nullable
    protected CEnchant[] get(Event e) {
        CEnchant ce = (CEnchant)this.ce.getSingle(e);
        CEnchant[] conf = new CEnchant[ce.getEnchant().getConflicts().size()];
        for (int x = 0; x < ce.getEnchant().getConflicts().size(); ++x) {
            conf[x] = new CEnchant(ce.getEnchant().getConflicts().get(x), 1);
        }
        return conf;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        CEnchant ce = (CEnchant)this.ce.getSingle(e);
        if (ce != null) {
            List<CustomEnchantment> lce = ce.getEnchant().getConflicts();
            switch (mode) {
                case RESET: 
                case DELETE: {
                    lce.clear();
                    break;
                }
                case SET: {
                    lce.clear();
                }
                case ADD: {
                    for (Object cce : delta) {
                        if (lce.contains(((CEnchant)cce).getEnchant())) continue;
                        lce.add(((CEnchant)cce).getEnchant());
                    }
                    break;
                }
                case REMOVE: {
                    for (Object cce : delta) {
                        if (!lce.contains(((CEnchant)cce).getEnchant())) continue;
                        lce.remove(((CEnchant)cce).getEnchant());
                    }
                    break;
                }
            }
            ce.getEnchant().setConflicts(lce);
            EnchantConfig.y.set("Enchantments." + ce.getEnchant().getId() + ".Conflicts", (Object)this.toString(lce));
            EnchantConfig.save();
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{CEnchant[].class});
        }
        return null;
    }

    public String toString(List<CustomEnchantment> conf) {
        String str = "";
        for (int x = 0; x < conf.size(); ++x) {
            String name = conf.get(x).getId();
            name = Character.toString(name.charAt(0)).toUpperCase() + name.substring(1);
            str = x == conf.size() - 1 && conf.size() > 1 ? str + " and " + name : (x > 0 ? str + ", " + name : str + name);
        }
        if (str.equals("")) {
            return null;
        }
        return str;
    }

    static {
        Registry.newSimple(ExprCEConflicts.class, "conflicts for %customenchantment%");
    }
}

