/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.github.tukenuke.tuske.TuSKe;
import com.github.tukenuke.tuske.documentation.Dependency;
import com.github.tukenuke.tuske.util.ReflectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import protocolsupport.api.ProtocolSupportAPI;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;
import us.myles.ViaVersion.bukkit.platform.BukkitViaAPI;

@Name(value="Minecraft Version")
@Description(value={"Returns the minecraft version of {{types|Player|player}}."})
@Examples(value={"on join:", "if minecraft version of player is \"1.9\":", "send \"You're joining with version %mc version of player%!\""})
@Since(value="1.0 (ProtocolSupport), 1.0.5 (ViaVersion)")
@Dependency(value="ProtocolSupport or ViaVersion")
public class ExprPlayerVersion
extends SimplePropertyExpression<Player, String> {
    private static boolean hasViaVersion = false;
    private static boolean hasProtocolSupport = Bukkit.getServer().getPluginManager().isPluginEnabled("ProtocolSupport");
    private static Object api;

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Nullable
    public String convert(Player p) {
        if (hasViaVersion) {
            int i = ((BukkitViaAPI)api).getPlayerVersion(p);
            return ProtocolVersion.getProtocol((int)i).getName().replace(".x", "");
        }
        if (hasProtocolSupport) {
            return ProtocolSupportAPI.getProtocolVersion((Player)p).getName();
        }
        return null;
    }

    protected String getPropertyName() {
        return "minecraft version";
    }

    static {
        JavaPlugin viaversion = (JavaPlugin)Bukkit.getServer().getPluginManager().getPlugin("ViaVersion");
        if (viaversion != null) {
            if (ReflectionUtils.hasMethod(ViaVersionPlugin.class, "getApi", new Class[0])) {
                hasViaVersion = true;
                api = ((ViaVersionPlugin)viaversion).getApi();
            } else {
                TuSKe.log("Couldn't hook with ViaVersion because it's outdated. Atleast version 1.0 is required.", Level.WARNING);
            }
        }
        if (hasViaVersion || hasProtocolSupport) {
            Registry.newProperty(ExprPlayerVersion.class, "(mc|minecraft) version", "player");
        }
    }
}

