/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.github.tukenuke.tuske.GitHubUpdater;
import com.github.tukenuke.tuske.Metrics;
import com.github.tukenuke.tuske.SimpleConfig;
import com.github.tukenuke.tuske.documentation.DefaultFile;
import com.github.tukenuke.tuske.documentation.Documentation;
import com.github.tukenuke.tuske.documentation.FileType;
import com.github.tukenuke.tuske.documentation.JsonFile;
import com.github.tukenuke.tuske.documentation.MarkdownFile;
import com.github.tukenuke.tuske.documentation.YamlFile;
import com.github.tukenuke.tuske.hooks.landlord.LandlordRegister;
import com.github.tukenuke.tuske.hooks.legendchat.LegendchatRegister;
import com.github.tukenuke.tuske.hooks.marriage.MarriageRegister;
import com.github.tukenuke.tuske.hooks.simpleclans.SimpleClansRegister;
import com.github.tukenuke.tuske.listeners.OnlineStatusCheck;
import com.github.tukenuke.tuske.manager.customenchantment.CustomEnchantment;
import com.github.tukenuke.tuske.manager.customenchantment.EnchantConfig;
import com.github.tukenuke.tuske.manager.customenchantment.EnchantManager;
import com.github.tukenuke.tuske.manager.gui.GUIManager;
import com.github.tukenuke.tuske.manager.gui.v2.SkriptGUIEvent;
import com.github.tukenuke.tuske.manager.recipe.RecipeManager;
import com.github.tukenuke.tuske.nms.NMS;
import com.github.tukenuke.tuske.nms.ReflectionNMS;
import com.github.tukenuke.tuske.util.Evaluate;
import com.github.tukenuke.tuske.util.ReflectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TuSKe
extends JavaPlugin {
    private static NMS nms;
    private static TuSKe plugin;
    private static GUIManager gui;
    private static RecipeManager recipes;
    private GitHubUpdater updater;

    public TuSKe() {
        if (plugin != null) {
            throw new IllegalStateException("TuSKe can't have two instances.");
        }
        plugin = this;
    }

    public void onEnable() {
        Boolean hasSkript = this.hasPlugin("Skript");
        if (!hasSkript.booleanValue() || !Skript.isAcceptRegistrations()) {
            if (!hasSkript.booleanValue()) {
                TuSKe.log("Error 404 - Skript not found.", Level.SEVERE);
            } else {
                TuSKe.log("TuSKe can't be loaded when the server is already loaded.", Level.SEVERE);
            }
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadConfig();
        EnchantConfig.loadEnchants();
        this.updater = new GitHubUpdater(this, this.getFile(), "Tuke-Nuke/TuSKe", this.getConfig().getBoolean("updater.download_pre_releases"));
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new OnlineStatusCheck(this), (Plugin)this);
        if (this.getConfig().getBoolean("use_metrics")) {
            new Metrics(this);
            TuSKe.log("Enabling Metrics... Done!");
        }
        if (this.getConfig().getBoolean("updater.check_for_new_update")) {
            this.checkUpdate();
            TuSKe.log("Check for updates enabled. It will check in some seconds.");
        }
        if (this.getConfig().getBoolean("documentation.enabled")) {
            TuSKe.log("Documentation enabled. Some files containing all syntax of all addons will be generated.");
            this.generateDocumentation();
        }
        TuSKe.log(" ");
        TuSKe.log(" A special thanks for donators:");
        TuSKe.log(" @X0Freak - 50$");
        TuSKe.log(" @RepublicanSensei - 10$");
        TuSKe.log(" ");
        SkriptAddon tuske = Skript.registerAddon((JavaPlugin)this).setLanguageFileDirectory("lang");
        try {
            tuske.loadClasses(((Object)((Object)this)).getClass().getPackage().getName(), new String[]{"register", "events", "conditions", "effects", "sections", "expressions"});
            if (this.hasPlugin("SimpleClans") || this.hasPlugin("SimpleClansLegacy")) {
                new SimpleClansRegister(tuske);
            }
            if (this.hasPlugin("Legendchat")) {
                new LegendchatRegister(tuske);
            }
            if (this.hasPlugin("Marriage")) {
                new MarriageRegister(tuske);
            }
            if (ReflectionUtils.hasClass("com.jcdesimp.landlord.persistantData.LowOwnedLand")) {
                new LandlordRegister(tuske);
            }
            this.info("Loaded %d events, %d conditions, %d effects, %d expressions and %d types. Have fun!", Registry.getResults());
        }
        catch (Exception e) {
            this.info("Error while registering stuffs. Please, report it at %s", this.getDescription().getWebsite() + "/issues");
            e.printStackTrace();
        }
    }

    public void onDisable() {
        SkriptGUIEvent.getInstance().unregisterAll();
        if (gui != null) {
            gui.clearAll();
        }
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.updater != null && this.getConfig().getBoolean("updater.check_for_new_update") && this.getConfig().getBoolean("updater.auto_update") && this.updater.hasDownloadReady(true)) {
            this.updater.updatePlugin();
        }
    }

    public static TuSKe getInstance() {
        return plugin;
    }

    public boolean hasPlugin(String str) {
        return plugin.getServer().getPluginManager().isPluginEnabled(str);
    }

    public void info(String msg, Object ... values) {
        TuSKe.log(String.format(msg, values), Level.INFO);
    }

    public void generateDocumentation() {
        FileType type;
        String config = this.getConfig().getString("documentation.file_type");
        switch (config.toLowerCase()) {
            case "yaml": 
            case "yml": {
                type = new YamlFile();
                break;
            }
            case "json": {
                type = new JsonFile(false);
                break;
            }
            case "raw_json": 
            case "raw json": {
                type = new JsonFile(true);
                break;
            }
            case "markdown": {
                type = new MarkdownFile();
                break;
            }
            case "default": 
            case "skript": 
            case "script": 
            case "sk": {
                type = new DefaultFile();
                break;
            }
            default: {
                TuSKe.log("Unknown value for 'documentation.file_type': " + config + ".");
                return;
            }
        }
        new Documentation(this, type).load();
    }

    public boolean onCommand(final CommandSender sender, Command cmd, String label, String[] arg) {
        if (cmd.getName().equalsIgnoreCase("tuske")) {
            if (arg.length > 0 && arg[0].equalsIgnoreCase("update")) {
                if (arg.length > 1 && arg[1].equalsIgnoreCase("download")) {
                    if (this.updater.hasDownloadReady(false) && this.getConfig().getBoolean("updater.auto_update")) {
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Already have a downloaded file ready to be updated.");
                    } else if (!this.updater.isLatestVersion()) {
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Downloading the latest version...");
                        this.updater.downloadLatest();
                        sender.sendMessage("\u00c2\u00a73The latest version was been dowloaded to TuSKe's folder.");
                    } else {
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73The plugin is already running the latest version!");
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("plugin")) {
                    if (!this.getConfig().getBoolean("updater.check_for_new_update")) {
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73The option 'check_for_new_update', in config file, needs to be true to check for updates.");
                    } else if (!this.updater.isLatestVersion() || this.updater.hasDownloadReady(true)) {
                        if (!this.updater.hasDownloadReady(false)) {
                            this.updater.downloadLatest();
                        }
                        this.getConfig().set("updater.auto_update", (Object)true);
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73The plugin will update when the server restarts.");
                    } else {
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73The plugin is already running the latest version!");
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("check")) {
                    sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Checking for update...");
                    this.updater.checkForUpdate(true);
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

                        @Override
                        public void run() {
                            if (!TuSKe.this.updater.isLatestVersion()) {
                                sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73New update available: \u00c2\u00a7cv" + TuSKe.this.updater.getLatestVersion());
                                if (sender instanceof Player) {
                                    TuSKe.this.sendDownloadRaw(sender);
                                } else {
                                    sender.sendMessage(new String[]{"\u00c2\u00a73Check what's new: \u00c2\u00a7c" + TuSKe.this.updater.getDownloadURL(), "\u00c2\u00a73You can download and update it with \u00c2\u00a7c/tuske update\u00c2\u00a73."});
                                }
                            } else {
                                sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73You are running the latest version: \u00c2\u00a7cv" + TuSKe.this.updater.getLatestVersion());
                            }
                        }
                    }, 1L);
                } else {
                    sender.sendMessage(new String[]{"\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Main commands of \u00c2\u00a7c" + arg[0] + "\u00c2\u00a73:", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " check \u00c2\u00a7e> \u00c2\u00a73Check for latest update.", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " download \u00c2\u00a7e> \u00c2\u00a73Download the latest update.", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " plugin \u00c2\u00a7e> \u00c2\u00a73Update the plugin after the server restarts."});
                }
            } else if (arg.length > 0 && arg[0].equalsIgnoreCase("reload")) {
                if (arg.length > 1 && arg[1].equalsIgnoreCase("config")) {
                    this.reloadConfig();
                    this.loadConfig();
                    sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Config reloaded!");
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("enchantments")) {
                    EnchantConfig.reload();
                    if (CustomEnchantment.getEnchantments().size() == 0) {
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73No enchantments were loaded. :(");
                    } else {
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73A total of \u00c2\u00a7c" + CustomEnchantment.getEnchantments().size() + "\u00c2\u00a73custom enchantments were loaded succesfully.");
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("docs")) {
                    sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Regenerating documentation files using \u00c2\u00a7c" + this.getConfig().getString("documentation.file_type") + " \u00c2\u00a73format.");
                    this.generateDocumentation();
                } else {
                    sender.sendMessage(new String[]{"\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Main commands of \u00c2\u00a7c" + arg[0] + "\u00c2\u00a73:", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " config \u00c2\u00a7e> \u00c2\u00a73Reload the config.", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " enchantments \u00c2\u00a7e> \u00c2\u00a73Reload the enchantments' file.", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " docs \u00c2\u00a7e> \u00c2\u00a7Regenerate new documentation files."});
                }
            } else if (arg.length > 0 && arg[0].matches("ench(antment)?")) {
                if (arg.length > 1 && arg[1].equalsIgnoreCase("list")) {
                    sender.sendMessage(new String[]{"\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73All registred enchantments:", "      \u00c2\u00a7eName       \u00c2\u00a7c-\u00c2\u00a7e ML \u00c2\u00a7c-\u00c2\u00a7e R \u00c2\u00a7c-\u00c2\u00a7e Enabled?"});
                    for (CustomEnchantment c : CustomEnchantment.getEnchantments()) {
                        sender.sendMessage("\u00c2\u00a7c" + this.left(c.getId(), 15) + " \u00c2\u00a74-\u00c2\u00a7c  " + c.getMaxLevel() + "  \u00c2\u00a74-\u00c2\u00a7c " + c.getRarity() + " \u00c2\u00a74- " + (c.isEnabledOnAnvil() ? "\u00c2\u00a7a" : "\u00c2\u00a7c") + c.isEnabledOnTable());
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("toggle")) {
                    String ench = this.getEnchantment(arg, 2);
                    if (arg.length > 2 && EnchantManager.isCustomByID(ench)) {
                        CustomEnchantment ce;
                        ce.setEnabledOnTable(!(ce = CustomEnchantment.getByID(ench)).isEnabledOnTable());
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73The enchantment \u00c2\u00a7c" + ce.getId() + "\u00c2\u00a73 was " + (ce.isEnabledOnTable() ? "\u00c2\u00a7aenabled" : "\u00c2\u00a7cdisabled") + "!");
                    } else if (arg.length > 2 && !EnchantManager.isCustomByID(ench)) {
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73There isn't any registred enchantment with ID \u00c2\u00a7c" + ench + "\u00c2\u00a73.");
                    } else {
                        sender.sendMessage(new String[]{"\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Use this command to enable/disable a enchantment.", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " toggle \u00c2\u00a74<\u00c2\u00a7cID\u00c2\u00a74> \u00c2\u00a7e> \u00c2\u00a73Enable/disable a enchantment."});
                    }
                } else if (arg.length > 1 && arg[1].equalsIgnoreCase("give")) {
                    if (sender instanceof Player) {
                        String ench = this.getEnchantment(arg, 2);
                        if (arg.length > 2 && EnchantManager.isCustomByID(ench)) {
                            Integer lvl = arg.length > 3 && this.isInteger(arg[arg.length - 1]) ? Integer.valueOf(arg[arg.length - 1]) : 1;
                            CustomEnchantment ce = CustomEnchantment.getByID(ench);
                            Player p = (Player)sender;
                            ItemStack i = p.getInventory().getItem(p.getInventory().getHeldItemSlot());
                            if (i != null && !i.getType().equals((Object)Material.AIR)) {
                                if (ce.isCompatible(i)) {
                                    if (!EnchantManager.addToItem(p.getInventory().getItem(p.getInventory().getHeldItemSlot()), ce, lvl, true)) {
                                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73The enchantment \u00c2\u00a7c" + ce.getId() + "\u00c2\u00a73 couldn't be added to your held item.");
                                    } else {
                                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73The enchantment \u00c2\u00a7c" + ce.getId() + "\u00c2\u00a73 was added to your held item.");
                                    }
                                } else {
                                    sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73The enchantment \u00c2\u00a7c" + ce.getId() + "\u00c2\u00a73 doesn't accept this item.");
                                }
                            } else {
                                sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73You have to hold a item first.");
                            }
                        } else if (arg.length > 2 && !EnchantManager.isCustomByID(ench)) {
                            sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73There isn't any registred enchantment with ID \u00c2\u00a7c" + ench + "\u00c2\u00a73.");
                        } else {
                            sender.sendMessage(new String[]{"\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Use this command to enchant your held item.", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " give \u00c2\u00a74<\u00c2\u00a7cID\u00c2\u00a74> \u00c2\u00a7c[\u00c2\u00a74<\u00c2\u00a7cLevel\u00c2\u00a74>\u00c2\u00a7c] \u00c2\u00a7e> \u00c2\u00a73Add a enchantment to your held item."});
                        }
                    } else {
                        sender.sendMessage("\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73This command is only for players.");
                    }
                } else {
                    sender.sendMessage(new String[]{"\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Main commands of \u00c2\u00a7c" + arg[0] + "\u00c2\u00a73:", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " list \u00c2\u00a7e> \u00c2\u00a73Shows a list of registered enchantment.", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " toggle \u00c2\u00a7e> \u00c2\u00a73Enable/disable a enchantment.", "\u00c2\u00a74/\u00c2\u00a7c" + label + " " + arg[0] + " give \u00c2\u00a7e> \u00c2\u00a73Add a enchantment to your held item."});
                }
            } else {
                sender.sendMessage(new String[]{"\u00c2\u00a7e[\u00c2\u00a7cTuSKe\u00c2\u00a7e] \u00c2\u00a73Main commands:", "\u00c2\u00a74/\u00c2\u00a7c" + label + " reload \u00c2\u00a7e> \u00c2\u00a73Reload config/enchantments.", "\u00c2\u00a74/\u00c2\u00a7c" + label + " update \u00c2\u00a7e> \u00c2\u00a73Check for latest update.", "\u00c2\u00a74/\u00c2\u00a7c" + label + " ench \u00c2\u00a7e> \u00c2\u00a73Manage the enchantments."});
            }
        }
        return true;
    }

    private String getEnchantment(String[] str, int id) {
        StringBuilder sb = new StringBuilder();
        sb.append("");
        for (int x = id; x < str.length; ++x) {
            if (x == str.length - 1 && this.isInteger(str[x])) continue;
            sb.append(str[x]);
            if (x >= str.length - 2) continue;
            sb.append(" ");
        }
        if (sb.toString().equals("") && str.length > id) {
            sb.append(str[id]);
        }
        return sb.toString();
    }

    private boolean isInteger(String arg) {
        return arg.matches("\\d+");
    }

    private String left(String s, int d) {
        StringBuilder sb = new StringBuilder(d);
        sb.append(s);
        while (sb.length() < d) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void loadConfig() {
        SimpleConfig sc = new SimpleConfig(this);
        sc.loadDefault();
        File f = new File(this.getDataFolder(), "config.yml");
        if (!f.exists()) {
            try {
                if (!this.getDataFolder().exists()) {
                    this.getDataFolder().mkdirs();
                }
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Evaluate.getInstance().parseConfig(this.getConfig());
        new Thread(() -> sc.save(f)).start();
    }

    private void sendDownloadRaw(CommandSender s) {
        if (s instanceof Player) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + s.getName() + " [{\"text\":\"\\u00a73Click \"},{\"text\":\"\\u00a7chere\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"\\u00a73Link to\n\\u00a77Git\u00a78Hub\"},\"clickEvent\":{\"action\":\"open_url\",\"value\":\"http://" + this.updater.getDownloadURL() + "\"}},{\"text\":\" \\u00a73to \\u00a73see \\u00a73what's \\u00a73new, \\u00a73click \"}, {\"text\":\"\\u00a7chere\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"\\u00a73Link to download\"},\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + this.updater.getDownloadURL() + "\"}},{\"text\":\" \\u00a73to \\u00a73download \\u00a73or \\u00a73use \\u00a73the \\u00a73command \"},{\"text\":\"\\u00a7c/tuske \\u00a7cupdate \\u00a7cdownload\",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"/tuske update download\"}},{\"text\":\" \\u00a73to \\u00a73download \\u00a73directly \\u00a73to \\u00a73TuSKe's \\u00a73folder. \\u00a73And \\u00a73you \\u00a73can \\u00a73use \"},{\"text\":\"\\u00a7c/tuske \\u00a7cupdate \\u00a7cplugin\",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"/tuske update plugin\"}}]"));
        }
    }

    public static RecipeManager getRecipeManager() {
        if (recipes == null) {
            recipes = new RecipeManager();
        }
        return recipes;
    }

    public static GUIManager getGUIManager() {
        if (gui == null) {
            gui = new GUIManager(TuSKe.getInstance());
        }
        return gui;
    }

    public static void log(String msg) {
        TuSKe.log(msg, Level.INFO);
    }

    public static void log(String msg, Level lvl) {
        plugin.getLogger().log(lvl, msg);
    }

    public static void log(Level lvl, String ... msgs) {
        for (String msg : msgs) {
            TuSKe.log(msg, lvl);
        }
    }

    public static boolean debug() {
        return plugin.getConfig().getBoolean("debug_mode");
    }

    public static void debug(Object ... objects) {
        if (!TuSKe.debug()) {
            return;
        }
        StackTraceElement caller = new Exception().getStackTrace()[1];
        TuSKe.log(String.format("[Debug] [%s, line %s] %s", caller.getFileName(), caller.getLineNumber(), StringUtils.join((Object[])objects, (String)" || ")));
    }

    public static NMS getNMS() {
        if (nms == null && (nms = (NMS)ReflectionUtils.newInstance(ReflectionUtils.getClass("me.tuke.sktuke.nms.M_" + ReflectionUtils.packageVersion))) == null) {
            nms = new ReflectionNMS();
            TuSKe.log("Couldn't find support for the Bukkit version '" + ReflectionUtils.packageVersion + "'. Some expressions, such as \"player data of %offline player%\", may or may not work fine, so it's better to ask the developer about it.", Level.WARNING);
        }
        return nms;
    }

    public static boolean isSpigot() {
        return ReflectionUtils.hasMethod(Player.class, "spigot", new Class[0]);
    }

    private void checkUpdate() {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
            TuSKe.log("Checking for latest update...");
            this.updater.checkForUpdate(true);
            if (this.updater.getLatestVersion() != null) {
                if (!this.updater.isLatestVersion()) {
                    if (this.getConfig().getBoolean("updater.auto_update")) {
                        this.updater.downloadLatest();
                        TuSKe.log("Downloaded the latest version. The plugin will be updated when the server restarts.");
                    } else {
                        TuSKe.log("New update available: v" + this.updater.getLatestVersion());
                        TuSKe.log("Check what's new in: " + this.updater.getURL());
                        TuSKe.log("You can download and update it with /tuske update.");
                    }
                } else {
                    TuSKe.log("No new update was found!");
                }
            }
        }, 10L);
    }
}

