/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.hooks.simpleclans.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ExprKillsOfPlayer
extends SimpleExpression<Number> {
    private Expression<Player> p;
    private int i;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.p = arg[0];
        this.i = arg3.mark;
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "kills of " + this.p;
    }

    @Nullable
    protected Number[] get(Event e) {
        Player p = (Player)this.p.getSingle(e);
        if (p != null) {
            ClanPlayer cp = SimpleClans.getInstance().getClanManager().getClanPlayer(p);
            if (cp != null) {
                switch (this.i) {
                    case 1: {
                        return new Number[]{cp.getRivalKills()};
                    }
                    case 2: {
                        return new Number[]{cp.getNeutralKills()};
                    }
                    case 3: {
                        return new Number[]{cp.getCivilianKills()};
                    }
                }
            }
            return null;
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ClanPlayer cp;
        Player p = (Player)this.p.getSingle(e);
        if (p != null && (cp = SimpleClans.getInstance().getClanManager().getClanPlayer(p)) != null) {
            int k = 0;
            if (delta != null) {
                k = ((Number)delta[0]).intValue();
            }
            switch (mode) {
                case ADD: {
                    switch (this.i) {
                        case 1: {
                            k += cp.getRivalKills();
                            break;
                        }
                        case 2: {
                            k += cp.getNeutralKills();
                            break;
                        }
                        case 3: {
                            k += cp.getCivilianKills();
                        }
                    }
                    break;
                }
                case REMOVE: {
                    switch (this.i) {
                        case 1: {
                            k = cp.getRivalKills() - k;
                            break;
                        }
                        case 2: {
                            k = cp.getNeutralKills() - k;
                            break;
                        }
                        case 3: {
                            k = cp.getCivilianKills() - k;
                        }
                    }
                    break;
                }
            }
            if (k < 0) {
                k = 0;
            }
            switch (this.i) {
                case 1: {
                    cp.setRivalKills(k);
                    break;
                }
                case 2: {
                    cp.setNeutralKills(k);
                    break;
                }
                case 3: {
                    cp.setCivilianKills(k);
                }
            }
            SimpleClans.getInstance().getStorageManager().updateClanPlayerAsync(cp);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    static {
        Registry.newProperty(ExprKillsOfPlayer.class, "clan (1\u00c2\u00a6rival|2\u00c2\u00a6neutral|3\u00c2\u00a6civilian) kills", "player");
    }
}

