/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.documentation;

import com.github.tukenuke.tuske.documentation.AddonInfo;
import com.github.tukenuke.tuske.documentation.FileType;
import com.github.tukenuke.tuske.documentation.SyntaxInfo;
import com.github.tukenuke.tuske.util.Util;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class DefaultFile
extends FileType {
    public DefaultFile() {
        super("sk");
    }

    @Override
    public void write(BufferedWriter writer, AddonInfo addon) throws IOException {
        StringJoiner joiner = new StringJoiner("\n");
        this.addSection(joiner, "Events", addon.getEvents());
        this.addSection(joiner, "Conditions", addon.getConditions());
        this.addSection(joiner, "Effects", addon.getEffects());
        this.addSection(joiner, "Expressions", addon.getExpressions());
        this.addSection(joiner, "Types", addon.getTypes());
        this.addSection(joiner, "Functions", addon.getFunctions());
        writer.write(joiner.toString());
    }

    private void addSection(StringJoiner joiner, String section, List<SyntaxInfo> list) {
        if (list.isEmpty()) {
            return;
        }
        joiner.add(section + ":");
        for (SyntaxInfo info : list) {
            this.addSyntax(joiner, info);
        }
    }

    private void addSyntax(StringJoiner joiner, SyntaxInfo info) {
        joiner.add("\t" + info.name + ":");
        for (Map.Entry<String, Object> entry : info.toMap().entrySet()) {
            if (entry.getKey().equals("Name")) continue;
            this.addEntry(joiner, entry.getKey(), entry.getValue());
        }
    }

    private void addEntry(StringJoiner joiner, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String && !Util.notEmpty((String)value)) {
            return;
        }
        if (value instanceof String[] && !Util.notEmpty((String[])value)) {
            return;
        }
        if (value instanceof String[]) {
            joiner.add("\t\t" + name + ":");
            for (String line : (String[])value) {
                joiner.add("\t\t\t" + line);
            }
        } else {
            joiner.add("\t\t" + name + ": " + value);
        }
    }
}

