/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

@Name(value="Cancel Drops")
@Description(value={"Cancels the drops of items, experiences or both in death events, where it won't drop the **player** items (like gamerule KeepInventory), or cancel the item drop of break block event (for minecraft 1.12+ only)."})
@Examples(value={"on death of player:", "\tcancel the drops #It won't drop the experience and items.", " ", "on break of diamond ore:", "\tcancel the drops of items #It won't drop the items only."})
@Since(value="1.0, 1.8.1 (block break event)")
public class EffCancelDrop
extends Effect {
    public static final boolean canCancelBreakDrops = Skript.isRunningMinecraft((int)1, (int)12);
    private int cancel = 1;

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        if (canCancelBreakDrops && !ScriptLoader.isCurrentEvent((Class[])new Class[]{PlayerDeathEvent.class, BlockBreakEvent.class}) || !canCancelBreakDrops && !ScriptLoader.isCurrentEvent(PlayerDeathEvent.class)) {
            Skript.error((String)("Can't use '" + arg3.expr + "' outside of death" + (canCancelBreakDrops ? " or break" : "") + " event"));
            return false;
        }
        if (arg2.isTrue()) {
            Skript.error((String)("Can't " + arg3.expr + " anymore after the event has already passed. It should be used before any wait effect."));
            return false;
        }
        this.cancel = arg1;
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "cancel drop";
    }

    protected void execute(Event e) {
        if (e instanceof PlayerDeathEvent) {
            PlayerDeathEvent pde = (PlayerDeathEvent)e;
            if (!pde.getKeepLevel() && this.cancel <= 1) {
                pde.setKeepLevel(true);
                pde.setDroppedExp(0);
            }
            if (this.cancel != 1) {
                pde.setKeepInventory(true);
            }
        } else if (canCancelBreakDrops && e instanceof BlockBreakEvent) {
            if (this.cancel <= 1) {
                ((BlockBreakEvent)e).setExpToDrop(0);
            }
            if (this.cancel != 1) {
                ((BlockBreakEvent)e).setDropItems(false);
            }
        }
    }

    static {
        Registry.newEffect(EffCancelDrop.class, "cancel [the] drops", "cancel [the] drops of [e]xp[perience][s]", "cancel [the] drops of (inventory|items)");
    }
}

