/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.blockeffect;

import com.github.tukenuke.tuske.TuSKe;
import com.github.tukenuke.tuske.blockeffect.BlockPosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Parser {
    private BlockPosition bp = new BlockPosition(0.0, 0.0, 0.0, 0, 1);
    int loopTimes = 0;
    String loop;
    String loopMatch;

    public boolean parser(String str) {
        TuSKe.debug(1, str);
        String match = null;
        if (str.matches("^\\((.+)\\)(\\d+).*")) {
            int bracket = this.getLastBracket(str);
            match = str.substring(1, bracket);
            Integer i = Integer.valueOf(str.replaceFirst("\\(" + this.fixBracket(match) + "\\)(\\d+).*", "$1"));
            String string = match;
            match = this.fixBracket("(" + match + ")" + i);
            this.parseLoop(i, string, match);
        } else if (str.matches("^(b|d|x|y|z)\\d+.*")) {
            this.parseBlock(str);
            match = "(b|d|x|y|z)\\d+";
        } else if (str.matches("^w\\d+(t|s|m)?.*")) {
            match = "w\\d+(t|s|m)?";
            Long t = Long.valueOf(str.replaceFirst("w(\\d+)(t|s|m)?.*", "$1"));
            if (str.matches("w(\\d+)s.*")) {
                t = t * 20L;
            } else if (str.matches("w(\\d+)m.*")) {
                t = t * 1200L;
            }
            final String str1 = str;
            final String match1 = match;
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)TuSKe.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Parser.this.parser(str1, match1);
                    if (Parser.this.loopTimes > 0) {
                        Parser.this.parseLoop(Parser.this.loopTimes, Parser.this.loop, Parser.this.loopMatch);
                    }
                }
            }, t.longValue());
            return false;
        }
        if (match != null) {
            return this.parser(str, match);
        }
        return true;
    }

    private void parseBlock(String str) {
        if (str.matches("^b\\d+.*")) {
            Integer i = Integer.valueOf(str.replaceFirst("(b|d|x|y|z)(\\d+).*", "$2"));
            this.bp.id = i;
        } else if (str.matches("^d\\d+.*")) {
            Integer i = Integer.valueOf(str.replaceFirst("(b|d|x|y|z)(\\d+).*", "$2"));
            this.bp.data = i.byteValue();
        } else if (str.matches("^x\\d+.*")) {
            Double i = Double.valueOf(str.replaceFirst("(b|d|x|y|z)(\\d+).*", "$2"));
            this.bp.x = i;
        } else if (str.matches("^y\\d+.*")) {
            Double i = Double.valueOf(str.replaceFirst("(b|d|x|y|z)(\\d+).*", "$2"));
            this.bp.y = i;
        } else if (str.matches("^z\\d+.*")) {
            Double i = Double.valueOf(str.replaceFirst("(b|d|x|y|z)(\\d+).*", "$2"));
            this.bp.z = i;
        }
    }

    private boolean parser(String str, String match) {
        if (!(str = str.replaceFirst(match, "")).equalsIgnoreCase("")) {
            return this.parser(str);
        }
        return false;
    }

    private void parseLoop(int times, String str, String match) {
        if (times-- > 0) {
            this.loopTimes = times;
            this.loop = str;
            this.loopMatch = match;
            if (this.parser(str)) {
                this.parseLoop(times, str, match);
            }
        } else {
            this.loopTimes = 0;
            this.loop = null;
            this.loopMatch = null;
        }
    }

    public <T> T getMatch(String str, String pattern, int group) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        if (m.find(group)) {
            return (T)m.group(group);
        }
        return null;
    }

    private String fixBracket(String str) {
        return str.replaceAll("(\\(|\\))", "\\\\$1");
    }

    public int getLastBracket(String str) {
        int foundOpen = 0;
        int foundClose = 0;
        for (int x = 0; x < str.length(); ++x) {
            char c = str.charAt(x);
            if (c == '(') {
                ++foundOpen;
            }
            if (c != ')' || ++foundClose != foundOpen) continue;
            return x;
        }
        return -1;
    }
}

