/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class ExprLeatherColor
extends SimpleExpression<Integer> {
    private Expression<?> i;
    private int rgb;

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.i = arg[0];
        this.rgb = arg3.mark;
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "leather " + (this.rgb == 0 ? "red" : (this.rgb == 1 ? "green" : "blue")) + " color of " + (this.i instanceof ItemStack ? "item stack" : "color");
    }

    @Nullable
    protected Integer[] get(Event e) {
        Color color = Color.fromRGB((int)0, (int)0, (int)0);
        if (this.i.getArray(e).length > 0 && this.i.getArray(e)[0] != null) {
            if (this.i.getArray(e)[0] instanceof ItemStack) {
                ItemMeta im = ((ItemStack)this.i.getArray(e)[0]).getItemMeta();
                if (im instanceof LeatherArmorMeta) {
                    color = ((LeatherArmorMeta)im).getColor();
                }
            } else {
                color = ((ch.njol.skript.util.Color)this.i.getArray(e)[0]).getBukkitColor();
            }
            switch (this.rgb) {
                case 0: {
                    return new Integer[]{color.getRed()};
                }
                case 1: {
                    return new Integer[]{color.getGreen()};
                }
                case 2: {
                    return new Integer[]{color.getBlue()};
                }
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (this.i.getArray(e).length > 0 && delta != null && this.i.getArray(e)[0] instanceof ItemStack) {
            for (ItemStack it : (ItemStack[])this.i.getArray(e)) {
                ItemMeta im;
                if (it == null || !((im = it.getItemMeta()) instanceof LeatherArmorMeta)) continue;
                Color color = ((LeatherArmorMeta)im).getColor();
                int value = ((Number)delta[0]).intValue();
                int from = 0;
                switch (this.rgb) {
                    case 0: {
                        from = color.getRed();
                        break;
                    }
                    case 1: {
                        from = color.getBlue();
                        break;
                    }
                    case 2: {
                        from = color.getGreen();
                    }
                }
                switch (mode) {
                    case ADD: {
                        value += from;
                        break;
                    }
                    case REMOVE: {
                        value = from - value;
                        break;
                    }
                }
                if (value < 0) {
                    value = 0;
                } else if (value > 255) {
                    value = 255;
                }
                switch (this.rgb) {
                    case 0: {
                        color = Color.fromRGB((int)value, (int)color.getGreen(), (int)color.getBlue());
                        break;
                    }
                    case 1: {
                        color = Color.fromRGB((int)color.getRed(), (int)value, (int)color.getBlue());
                        break;
                    }
                    case 2: {
                        color = Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)value);
                    }
                }
                ((LeatherArmorMeta)im).setColor(color);
                it.setItemMeta(im);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    static {
        Registry.newProperty(ExprLeatherColor.class, "[leather] (0\u00c2\u00a6red|1\u00c2\u00a6green|2\u00c2\u00a6blue) colo[u]r", "-itemstacks/colors");
    }
}

