/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.manager.gui.v2;

import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.tuke.sktuke.listeners.GUIListener;
import me.tuke.sktuke.util.ReflectionUtils;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;

public class SkriptGUIEvent
extends SkriptEvent {
    private static SkriptGUIEvent instance;
    private final Map<Class, List<Trigger>> triggers = (Map)ReflectionUtils.getField(SkriptEventHandler.class, null, "triggers");
    private final List<GUIListener> listeners = new ArrayList<GUIListener>();

    public static SkriptGUIEvent getInstance() {
        if (instance == null) {
            instance = new SkriptGUIEvent();
        }
        return instance;
    }

    private SkriptGUIEvent() {
        Trigger t = new Trigger(null, "gui inventory click", (SkriptEvent)this, new ArrayList());
        this.addTrigger(t, 0, InventoryClickEvent.class, InventoryDragEvent.class);
        this.addTrigger(t, 1, InventoryCloseEvent.class);
        ReflectionUtils.invokeMethod(SkriptEventHandler.class, "registerBukkitEvents", null, new Object[0]);
    }

    public boolean check(Event event) {
        ArrayList<GUIListener> current = new ArrayList<GUIListener>(this.listeners);
        for (GUIListener gui : current) {
            gui.onEvent(event);
            if (!(event instanceof Cancellable) || !((Cancellable)event).isCancelled()) continue;
            break;
        }
        return false;
    }

    public void register(GUIListener gui) {
        this.listeners.add(gui);
    }

    public void unregister(GUIListener gui) {
        this.listeners.remove(gui);
    }

    public void unregisterAll() {
        this.listeners.forEach(GUIListener::finalize);
        this.listeners.clear();
    }

    private void addTrigger(Trigger t, int priority, Class<? extends Event> ... clzz) {
        if (priority == 0) {
            for (Class<? extends Event> clz : clzz) {
                List<Trigger> current = this.triggers.get(clz);
                ArrayList<Trigger> newList = new ArrayList<Trigger>();
                if (current == null) {
                    newList.add(t);
                    this.triggers.put(clz, newList);
                    continue;
                }
                newList.addAll(current);
                current.clear();
                current.add(t);
                current.addAll(newList);
            }
        } else {
            Method m = ReflectionUtils.getMethod(SkriptEventHandler.class, "addTrigger", clzz.getClass(), Trigger.class);
            ReflectionUtils.invokeMethod(m, null, clzz, t);
        }
    }

    public boolean init(Literal<?>[] literals, int i, SkriptParser.ParseResult parseResult) {
        return true;
    }

    public String toString(Event event, boolean b) {
        return event != null ? "gui event: " + event.getEventName() : "gui event";
    }
}

