/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.hooks.simpleclans.events;

import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import java.util.ArrayList;
import java.util.List;
import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.hooks.simpleclans.ClanChatEvent;
import me.tuke.sktuke.util.ReflectionUtils;
import me.tuke.sktuke.util.Registry;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class EvtChatClan
extends SelfRegisteringSkriptEvent
implements Listener {
    private static List<Trigger> triggers;
    private static final SimpleClans plugin;
    private static boolean lastConfigValue;

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent e) {
        if (e.getMessage().isEmpty() || e.getPlayer() == null || plugin.getSettingsManager().isBlacklistedWorld(e.getPlayer().getWorld().getName())) {
            return;
        }
        String[] sp = e.getMessage().substring(1).split("\\s+");
        String cmd = sp[0];
        ClanPlayer cp = null;
        if (plugin.getSettingsManager().isTagBasedClanChat() ? (cp = plugin.getClanManager().getClanPlayer(e.getPlayer())) == null && !cp.getTag().equalsIgnoreCase(cmd) : !cmd.equals(".")) {
            return;
        }
        if (cp == null) {
            cp = plugin.getClanManager().getClanPlayer(e.getPlayer());
        }
        if (cp != null && sp.length > 1) {
            ClanChatEvent cce = new ClanChatEvent(cp, Helper.toMessage((String[])Helper.removeFirst((String[])sp)));
            SkriptEventHandler.logEventStart((Event)cce);
            for (Trigger t : triggers) {
                SkriptEventHandler.logTriggerStart((Trigger)t);
                t.execute((Event)cce);
                SkriptEventHandler.logTriggerEnd((Trigger)t);
            }
            SkriptEventHandler.logEventEnd();
            if (!cce.isCancelled()) {
                e.setCancelled(true);
                plugin.getClanManager().processClanChat(cce.getClanPlayer().toPlayer(), cce.getMessage());
            }
        }
    }

    public void init() {
        if (triggers.size() == 1 && (lastConfigValue = ((Boolean)ReflectionUtils.getField(plugin.getSettingsManager().getClass(), plugin.getSettingsManager(), "clanChatEnable")).booleanValue())) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TuSKe.getInstance());
            ReflectionUtils.setField(plugin.getSettingsManager().getClass(), plugin.getSettingsManager(), "clanChatEnable", false);
        }
    }

    public void finalize() {
        if (triggers.size() == 0) {
            ReflectionUtils.setField(plugin.getSettingsManager().getClass(), plugin.getSettingsManager(), "clanChatEnable", lastConfigValue);
            HandlerList.unregisterAll((Listener)this);
        }
    }

    public void register(Trigger trigger) {
        triggers.add(trigger);
        this.init();
    }

    public void unregister(Trigger trigger) {
        triggers.remove(trigger);
        this.finalize();
    }

    public void unregisterAll() {
        triggers.clear();
        this.finalize();
    }

    public boolean init(Literal<?>[] literals, int i, SkriptParser.ParseResult parseResult) {
        return true;
    }

    public String toString(Event event, boolean b) {
        return "clan chat event";
    }

    static {
        Registry.newEvent(EvtChatClan.class, ClanChatEvent.class, "Clan Chat", "clan chat");
        triggers = new ArrayList<Trigger>();
        plugin = SimpleClans.getInstance();
        lastConfigValue = true;
    }
}

