/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions.recipe;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.manager.recipe.RecipeManager;
import me.tuke.sktuke.util.Registry;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;

@Name(value="Knowledge Recipes")
@Description(value={"It returns a list of recipes of a knowledge book. You can either set, add and remove recipes, and clear/delete them all."})
@Examples(value={"set {_recipes::*} to knowledge recipes of held item #The held item must a be knowledge book", "add all recipes to knowledges of {_book}", "remove recipes of held item from knowledges of {_book}", "clear knowledges of held item"})
@Since(value="1.8")
public class ExprKnowledgesOfItem
extends SimpleExpression<Recipe> {
    private Expression<ItemStack> item;

    protected Recipe[] get(Event event) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        RecipeManager rm = TuSKe.getRecipeManager();
        for (ItemStack item : (ItemStack[])this.item.getArray(event)) {
            if (item == null || item.getType() != Material.KNOWLEDGE_BOOK || !item.hasItemMeta()) continue;
            KnowledgeBookMeta meta = (KnowledgeBookMeta)item.getItemMeta();
            for (NamespacedKey key : meta.getRecipes()) {
                Recipe r = rm.getRecipeFromKey(key);
                if (r == null) continue;
                recipes.add(r);
            }
        }
        return recipes.toArray(new Recipe[recipes.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Recipe> getReturnType() {
        return Recipe.class;
    }

    public String toString(Event event, boolean b) {
        return "knowledges of " + this.item.toString(event, b);
    }

    public boolean init(Expression<?>[] arg, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.item = arg[0];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL && mode != Changer.ChangeMode.RESET) {
            return new Class[]{Recipe[].class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        for (ItemStack item : (ItemStack[])this.item.getArray(e)) {
            if (item == null || item.getType() != Material.KNOWLEDGE_BOOK) continue;
            KnowledgeBookMeta meta = (KnowledgeBookMeta)(item.hasItemMeta() ? item.getItemMeta() : Bukkit.getItemFactory().getItemMeta(Material.KNOWLEDGE_BOOK));
            ArrayList<NamespacedKey> list = new ArrayList<NamespacedKey>(meta.getRecipes());
            if (mode != Changer.ChangeMode.ADD && mode != Changer.ChangeMode.REMOVE) {
                list.clear();
            }
            if (delta != null) {
                block5: for (Object recipe : delta) {
                    if (!(recipe instanceof Keyed)) continue;
                    switch (mode) {
                        case REMOVE: {
                            list.remove(((Keyed)recipe).getKey());
                            continue block5;
                        }
                        case ADD: 
                        case SET: {
                            list.add(((Keyed)recipe).getKey());
                        }
                    }
                }
            }
            meta.setRecipes(new ArrayList());
            meta.addRecipe(list.toArray(new NamespacedKey[list.size()]));
            item.setItemMeta((ItemMeta)meta);
        }
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)12)) {
            Registry.newProperty(ExprKnowledgesOfItem.class, "knowledge(s| recipes)", "itemstack");
        }
    }
}

