/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import javax.annotation.Nullable;
import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.util.Registry;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@Name(value="Player Data")
@Description(value={"Returns a {{types|OfflinePlayer|offline player}} as it was a player, which means that you can get some values like money, inventory, enderchest,etc. Maybe all values doesn't work. If you want to change these values, you will have to {{effects|SavePlayerData|save player data}}."})
@Examples(value={"command /money <offlineplayer>:", "\ttrigger:", "\t\tif arg is not online:", "send \"%money of player data of arg%\""})
@Since(value="1.1")
public class ExprOfflineData
extends SimplePropertyExpression<OfflinePlayer, Player> {
    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    @Nullable
    public Player convert(OfflinePlayer p) {
        Player player;
        if (!p.isOnline() && (player = TuSKe.getNMS().getToPlayer(p)) != null) {
            return player;
        }
        return null;
    }

    protected String getPropertyName() {
        return "player data";
    }

    static {
        Registry.newProperty(ExprOfflineData.class, "player data", "offlineplayer");
    }
}

