/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleConfig {
    private JavaPlugin pl;
    private HashMap<String, String> map = new HashMap();

    public SimpleConfig(JavaPlugin plugin) {
        this.pl = plugin;
    }

    public void loadDefault() {
        this.setDefault("use_metrics", true, "#Use metrics to send anonymous data about your server. The data that", "#is sent are:", "#", "#Players currently online (not max player count)", "#Version of the server (the same version you see in /version)", "#Version of this plugin", "#", "#If you don't agree with this, you can set it to false freely.", "#These values will be used only for statistic for this plugin.");
        this.setDefault("updater.check_for_new_update", true, "#It will check for new update everytime the server starts or", "#when someone use the command /tuske update check");
        this.setDefault("updater.auto_update", false, "#It will auto update the plugin. When there is a new version,", "#the plugin will download it and update when the server restarts.", "#Warning: I can't guarantee that the plugin is free of bugs that", "#can come in newest updates. I don't recommend to use in your main", "#server.", "#You can still download/update your plugin by command, see more in", "#/tuske update");
        this.setDefault("updater.download_pre_releases", this.pl.getDescription().getVersion().contains("beta"), "#Download pre-releases.", "#Note: pre-releases versions shoudln't be used in your main server.", "#It's just to test new incomming features only!!");
        this.addComentsAbove("disable", "#This option will be for future things of TuSKe.", "#It will be used when there is some features that isn't available", "#or uncompatible with your version. For now, it doesn't do nothing", "#but it tends to disable some crashing expression or lagging event", "#", "#true if you want to disable. (not implemented yet)");
        this.setDefault("disable.SomeExample", true, new String[0]);
        this.setDefault("debug_mode", false, "#This option will be for future things of TuSKe.", "#It will just show some debug messages if needed.", "#So far, it doesn't do nothing, only prevent some testing debug messages", "#that can be accidentaly forgot inside the code.");
        this.setDefault("warn_unsafe_expressions", true, "#It will be used to warn about expressions that may have risk to your server,", "#The warn is sent when reloading a script and it won't prevent the expression to work.", "#An example is the expression 'random strings matching %regex%'.");
        this.setDefault("use_only_enum_names", false, "#This is only needed in case of conflict with Skript or another addon", "#It will make some types, that is registered by TuSKe and if the type is a Enum,", "#to accept the form as '<Enum type>.<Enum name>'", "#For example, TuSKe register the type 'InventoryType' for the expression to create inventories", "#So, in case the value 'chest' is conflicting with something else, just enable it and", "#it will only accept if used like 'InventoryType.CHEST'", "#Example:", "#\topen virtual InventoryType.CHEST inventory with size 1 named \"Hi\" to player", "#Don't need to worry about it, is just in case.");
        this.addComentsAbove("documentation", "#A documentation that will be generated at 'plugins/TuSKe/documentation/'", "#for all addons");
        this.setDefault("documentation.enabled", true, "#Should documentation be generated?");
        this.addComentsAbove("evaluate_filter", "#Filter some effects/conditions/expressions from being used in evaluate effects.", "#First, go to '/TuSKe/documentation' and get every syntax you don't want to be used in", "#eval effect. Add them in list below and reload the config with '/tuske reload config'.", "#Notes:", "#  - You need to include 'with safety' in your evaluate effect. i.e.", "#    \tevaluate with safety: stop server #It will actually check if 'stop server' is allowed or not", "#  - If you have SkQuery, you might need to disallow its evaluate effect as well.", "#  - The performance may be decreased depending of amount of syntaxes. Use it only for public reasons.");
        this.setDefault("evaluate_filter.mode", "blacklist", "#Mode to filter syntaxes: whitelist or blacklist");
        this.setDefault("evaluate_filter.syntaxes", new String[]{"op %player%", "stop server"}, "#A list of syntaxes to add to whitelist/blacklist.", "#Use quotes to properly use the yaml file, example:", "#- \"kill %player%\"");
        String str = "use-metrics";
        if (this.pl.getConfig().isBoolean(str)) {
            this.pl.getConfig().set(str.replaceAll("\\-", "_"), (Object)this.pl.getConfig().getBoolean(str));
            this.pl.getConfig().set(str, null);
        }
        for (String var : new String[]{"check-for-new-update", "auto-update"}) {
            if (!this.pl.getConfig().isBoolean(var)) continue;
            this.pl.getConfig().set("updater." + var.replaceAll("-", "_"), (Object)this.pl.getConfig().getBoolean(var));
            this.pl.getConfig().set(var, null);
        }
    }

    private boolean setDefault(String path, Object value, String ... comments) {
        Object obj;
        if (comments.length > 0) {
            this.addComentsAbove(path, comments);
        }
        if ((obj = this.pl.getConfig().get(path)) == null || !obj.getClass().equals(value.getClass()) && !value.getClass().isArray()) {
            this.pl.getConfig().set(path, value);
            return true;
        }
        return false;
    }

    private boolean addComentsAbove(String path, String ... comments) {
        if (!this.map.containsKey(path)) {
            this.map.put(path, (this.map.size() > 0 ? "\n" : "") + StringUtils.join((Object[])comments, (String)"\n"));
            return true;
        }
        return false;
    }

    public void save(File file) {
        try {
            String str = this.saveToString();
            if (str == null) {
                return;
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(str);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String saveToString() {
        if (this.map.size() == 0) {
            return null;
        }
        String toFile = this.pl.getConfig().saveToString();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String key = entry.getKey();
            String comment = entry.getValue();
            int last = key.split("\\.").length - 1;
            String space = "";
            for (int x = 0; x < last; ++x) {
                space = space + "  ";
            }
            comment = comment.replaceAll("\n", "\n" + space) + "\n";
            String regex = this.keyToRegex(key);
            if (!key.equalsIgnoreCase(regex)) {
                toFile = toFile.replaceFirst("(?s)" + regex, "$1$2" + comment + space + "$3");
                continue;
            }
            toFile = toFile.replaceFirst(key, comment + key);
        }
        this.map.clear();
        return toFile;
    }

    private String keyToRegex(String key) {
        return key.replaceAll("^((\\w+(\\s+|\\-)?)+)(\\.(.+\\.)?)((\\w+(\\s+|\\-)?)+)$", "($1:)(.+)($6:)");
    }
}

