/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bukkit.plugin.java.JavaPlugin;

public class SkUnityUpdater {
    private JavaPlugin PLUGIN;
    private int ID;
    private String CHANGE_LOG;
    private File PLUGIN_JAR;
    private String DOWNLOAD_REGEX;
    private String URL = null;
    private String THREAD_TITLE = null;
    private String LATEST_VERSION = null;
    private Pattern PATTERN_1 = Pattern.compile(".*(v(\\w+\\.?)+)(.*)");
    private Pattern PATTERN_2;

    public SkUnityUpdater(JavaPlugin instance, File pluginFile, int threadID) {
        this(instance, pluginFile, threadID, String.valueOf(instance.getName()) + ".jar");
    }

    public SkUnityUpdater(JavaPlugin instance, File pluginFile, int threadID, String downloadRegex) {
        this.PLUGIN_JAR = pluginFile;
        this.PLUGIN = instance;
        this.ID = threadID;
        this.PATTERN_2 = Pattern.compile(".*" + instance.getName() + "\\s+((\\w+\\.?)+)(.*)");
        this.DOWNLOAD_REGEX = downloadRegex;
    }

    public boolean checkForUpdate(boolean showMessageError) throws IllegalArgumentException {
        block12: {
            try {
                HttpURLConnection forum = (HttpURLConnection)new URL("https://forums.skunity.com/t/" + this.ID + "/1").openConnection();
                forum.setRequestProperty("User-Agent", "Mozilla/5.0");
                String page = IOUtils.toString((InputStream)forum.getInputStream(), (String)"UTF-8");
                if (page.contains("<title>")) {
                    this.THREAD_TITLE = page.split("<title>")[1].split(" - Addons - skUnity Forums")[0];
                    Matcher m = this.PATTERN_1.matcher(this.THREAD_TITLE);
                    if (!m.find(1)) {
                        m = this.PATTERN_2.matcher(this.THREAD_TITLE);
                    }
                    if (m.find(1)) {
                        this.LATEST_VERSION = m.group(1);
                        if (this.LATEST_VERSION.toLowerCase().startsWith("v")) {
                            this.LATEST_VERSION = this.LATEST_VERSION.substring(1);
                        }
                    }
                }
                if (page.contains("Changelog:")) {
                    this.CHANGE_LOG = page.split("<strong>Changelog:</strong> <a href=\"")[1].split("\">#")[0];
                }
                if (page.contains("\">" + this.DOWNLOAD_REGEX) && page.contains("Download:</strong> <a class=\"attachment\" href=\"")) {
                    this.URL = page.split("Download:</strong> <a class=\"attachment\" href=\"")[1].split("\">" + this.DOWNLOAD_REGEX)[0];
                    if (this.URL.startsWith("/uploads/default/original/")) {
                        this.URL = "https://forums.skunity.com" + this.URL;
                    }
                    if (!this.URL.startsWith("http") && !this.URL.startsWith("www")) {
                        this.URL = "https://" + this.URL;
                    }
                }
                return true;
            }
            catch (MalformedURLException e) {
                if (showMessageError) {
                    this.PLUGIN.getLogger().severe("The updater couldn't get the link of the latest version.\n" + e.getMessage());
                }
            }
            catch (IOException e) {
                if (!showMessageError) break block12;
                this.PLUGIN.getLogger().warning("An unexpected error occurred when trying to check for latest update. Maybe SkUnity is down?");
            }
        }
        return false;
    }

    public void useDirectURL(String URL2) {
        this.URL = URL2;
    }

    public void backupCurrent() {
        File jarTo = new File(this.PLUGIN.getDataFolder(), String.valueOf(this.PLUGIN.getName()) + "-backup.jar");
        File jarOld = new File("plugins" + File.separator, this.PLUGIN_JAR.getName());
        try {
            if (jarTo.exists()) {
                jarTo.delete();
            }
            jarOld.renameTo(new File(jarOld.getPath().replace(".jar", "-backup.jar")));
            jarOld = new File("plugins" + File.separator, this.PLUGIN_JAR.getName().replaceAll(".jar", "-backup.jar"));
            FileUtils.copyFileToDirectory((File)jarOld, (File)new File(this.PLUGIN.getDataFolder() + File.separator));
        }
        catch (IOException e) {
            this.PLUGIN.getLogger().warning("An unexpected error occurred when trying to make a backup of current version.\n" + e.getMessage());
        }
    }

    public void updatePlugin(boolean backupCurrentVersion) {
        if (this.hasDownloadReady(true)) {
            File jarNew = new File(this.PLUGIN.getDataFolder(), String.valueOf(this.PLUGIN.getName()) + ".jar");
            File jarOld = new File("plugins" + File.separator, this.PLUGIN_JAR.getName());
            try {
                if (backupCurrentVersion) {
                    this.backupCurrent();
                }
                jarOld.delete();
                FileUtils.copyFileToDirectory((File)jarNew, (File)new File("plugins" + File.separator));
                jarNew.delete();
            }
            catch (IOException e) {
                this.PLUGIN.getLogger().severe("An unexpected error occurred when trying to update the plugin.\n" + e.getMessage());
            }
        }
    }

    public String getLatestVersion() {
        return this.LATEST_VERSION;
    }

    public String getThreadTitle() {
        return this.THREAD_TITLE;
    }

    public String getThreadURL() {
        return "https://forums.skunity.com/t/" + this.ID;
    }

    public String getChangeLogURL() {
        return this.CHANGE_LOG;
    }

    public String getDownloadURL() {
        return this.URL;
    }

    public boolean isLatestVersion() {
        return this.PLUGIN.getDescription().getVersion().equals(this.LATEST_VERSION);
    }

    public boolean hasDownloadReady(boolean ignoreVersion) {
        return new File(this.PLUGIN.getDataFolder(), String.valueOf(this.PLUGIN.getName()) + ".jar").exists() && (ignoreVersion || !this.isLatestVersion());
    }

    public boolean downloadLatest() {
        try {
            HttpURLConnection download = (HttpURLConnection)new URL(this.URL).openConnection();
            download.setRequestProperty("User-Agent", "Mozilla/5.0");
            File f = new File(this.PLUGIN.getDataFolder(), String.valueOf(this.PLUGIN.getName()) + ".jar");
            if (f.exists()) {
                f.delete();
            }
            FileUtils.copyInputStreamToFile((InputStream)download.getInputStream(), (File)f);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

