/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.sections.gui;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.tuke.sktuke.manager.gui.v2.GUIHandler;
import me.tuke.sktuke.manager.gui.v2.GUIInventory;
import me.tuke.sktuke.sections.gui.EffCreateGUI;
import me.tuke.sktuke.util.EffectSection;
import me.tuke.sktuke.util.Registry;
import me.tuke.sktuke.util.VariableUtil;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

@Name(value="Make GUI")
@Description(value={"Used to format a gui slot inside of gui creation/editing section"})
public class EffMakeGUI
extends EffectSection {
    public static EffMakeGUI lastInstance;
    private EffCreateGUI currentSection = null;
    private Expression<?> slot;
    private Expression<ItemStack> item;
    private int type;

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        if (this.checkIfCondition()) {
            return false;
        }
        if (EffCreateGUI.lastInstance == null) {
            Skript.error((String)"You can't make a gui outside of 'create/edit gui' effect.");
            return false;
        }
        this.type = arg1++;
        if (arg.length > 0 && arg1 <= 2) {
            this.item = arg[arg.length - 1];
        }
        if (arg1 % 2 == 0) {
            this.slot = arg[0].getConvertedExpression(new Class[]{Object.class});
        }
        this.currentSection = EffCreateGUI.lastInstance;
        if (this.hasSection()) {
            EffMakeGUI last = lastInstance;
            lastInstance = this;
            this.loadSection("gui effect", InventoryClickEvent.class);
            lastInstance = last;
        }
        return true;
    }

    @Override
    public void execute(Event e) {
        Object[] slot;
        Object[] objectArray;
        GUIInventory gui = this.currentSection.gui;
        if (gui == null) {
            return;
        }
        if (this.type > 1) {
            Object[] objectArray2;
            if (this.slot != null) {
                objectArray2 = this.slot.getArray(e);
            } else if (this.type == 4) {
                objectArray2 = null;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = Character.valueOf(gui.nextInvertedSlot());
            }
            Object[] slots = objectArray2;
            gui.clearSlots(slots);
            return;
        }
        ItemStack item = (ItemStack)this.item.getSingle(e);
        if (this.slot != null) {
            objectArray = this.slot.getArray(e);
        } else {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = Character.valueOf(gui.nextSlot());
        }
        for (Object s : slot = objectArray) {
            if (this.hasSection()) {
                Object variables = VariableUtil.getInstance().copyVariables(e);
                gui.setItem(s, item, event -> {
                    VariableUtil.getInstance().pasteVariables((Event)event, variables);
                    GUIHandler.getInstance().setGUIEvent((Event)event, gui);
                    this.runSection((Event)event);
                });
                continue;
            }
            gui.setItem(s, item);
        }
    }

    public String toString(Event arg0, boolean arg1) {
        if (this.type > 1) {
            return "unmake gui slot";
        }
        return "make " + (this.slot != null ? " a gui slot " + this.slot.toString(arg0, arg1) : "next gui slot") + " of gui with " + this.item.toString(arg0, arg1);
    }

    static {
        Registry.newEffect(EffMakeGUI.class, "(make|format) next gui [slot] (with|to) %itemstack%", "(make|format) gui [slot] %strings/numbers% (with|to) %itemstack%", "(un(make|format)|remove) next gui [slot]", "(un(make|format)|remove) gui [slot] %strings/numbers%", "(un(make|format)|remove) all gui [slot]");
        lastInstance = null;
    }
}

