/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.manager.gui.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import me.tuke.sktuke.listeners.GUIListener;
import me.tuke.sktuke.util.InventoryUtils;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GUIInventory {
    private static final Consumer<InventoryClickEvent> nullConsumer = e -> {};
    private String rawShape;
    private String id;
    private Map<Character, Consumer<InventoryClickEvent>> slots = new HashMap<Character, Consumer<InventoryClickEvent>>();
    private Map<Character, ItemStack> items = new HashMap<Character, ItemStack>();
    private Consumer<InventoryCloseEvent> onClose;
    private Inventory inv;
    private GUIListener listener;
    private boolean isLocked = false;

    public GUIInventory(Inventory inv) {
        this.inv = inv;
    }

    public GUIInventory setID(String id) {
        this.id = id;
        return this;
    }

    public GUIInventory shape(String ... shapes) {
        StringBuilder sb = new StringBuilder();
        for (String shape : shapes) {
            sb.append(shape);
        }
        while (sb.length() < this.inv.getSize()) {
            sb.append(' ');
        }
        this.rawShape = sb.toString();
        return this;
    }

    public GUIInventory shapeDefault() {
        StringBuilder sb = new StringBuilder();
        for (char c = 'A'; c < this.inv.getSize() + 65; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        this.rawShape = sb.toString();
        return this;
    }

    public String getRawShape() {
        return this.rawShape;
    }

    public GUIInventory lockSlots() {
        this.isLocked = !this.isLocked;
        return this;
    }

    public boolean isSlotsLocked() {
        return this.isLocked;
    }

    public GUIInventory setItem(Object slot, ItemStack item) {
        return this.setItem(slot, item, nullConsumer);
    }

    public GUIInventory setItem(Object slot, ItemStack item, Consumer<InventoryClickEvent> con) {
        char ch = this.convert(slot);
        if (ch == '\u0000') {
            return this;
        }
        if (ch == '+' && this.rawShape.contains("+")) {
            char ch2 = 'A';
            while (this.rawShape.indexOf(ch2) >= 0) {
                ch2 = (char)(ch2 + 1);
            }
            this.rawShape = this.rawShape.replaceFirst("\\+", "" + ch2);
            ch = ch2;
        }
        this.slots.put(Character.valueOf(ch), con);
        this.setItem(ch, item);
        return this;
    }

    public GUIInventory changeProperties(String newName, int newSize, String newRawShape, int shapeMode) {
        ItemStack[] copy = this.inv.getContents();
        if (newRawShape != null) {
            if (shapeMode < 2) {
                ItemStack[] newItems = (ItemStack[])copy.clone();
                int length = this.inv.getType() == InventoryType.CHEST ? 9 * newSize : newItems.length;
                copy = new ItemStack[length];
                int x = 0;
                HashMap<Character, ItemStack> items = new HashMap<Character, ItemStack>();
                for (char ch1 : this.rawShape.toCharArray()) {
                    if (x >= newItems.length) continue;
                    items.put(Character.valueOf(ch1), newItems[x++]);
                }
                x = 0;
                for (char ch : newRawShape.toCharArray()) {
                    ItemStack item = (ItemStack)items.get(Character.valueOf(ch));
                    if (item != null && x < copy.length) {
                        copy[x] = item;
                    }
                    ++x;
                }
            }
            if (shapeMode % 2 == 0) {
                this.rawShape = newRawShape;
            }
        }
        if (newName != null && newSize >= 0) {
            ArrayList viewers = new ArrayList(this.inv.getViewers());
            if (newSize == 0) {
                newSize = this.inv.getSize() / 9;
            }
            this.inv = InventoryUtils.newInventory(this.inv.getType(), newSize, newName);
            if (this.inv == null) {
                return this;
            }
            this.inv.setContents(copy);
            viewers.forEach(human -> {
                ItemStack cursor = human.getItemOnCursor();
                human.setItemOnCursor(null);
                human.openInventory(this.inv);
                human.setItemOnCursor(cursor);
            });
        } else {
            this.inv.setContents(copy);
        }
        return this;
    }

    private void setItem(char ch, ItemStack item) {
        if (this.listener == null && (this.inv.getHolder() == null || this.inv.getViewers().size() == 0)) {
            this.items.put(Character.valueOf(ch), item);
            return;
        }
        int x = -1;
        for (char ch1 : this.rawShape.toCharArray()) {
            if (++x >= this.inv.getSize() || ch1 != ch) continue;
            this.inv.setItem(x, item);
        }
    }

    public Consumer<InventoryClickEvent> getSlot(Integer slot) {
        return slot != null ? this.getSlot(Character.valueOf(this.convertSlot(slot))) : null;
    }

    public Consumer<InventoryClickEvent> getSlot(Character ch) {
        if (ch != null) {
            return this.slots.get(ch);
        }
        return null;
    }

    public GUIInventory clearSlots(Object ... chars) {
        if (chars == null || chars.length == 0) {
            this.clear();
        } else {
            for (Object ch : chars) {
                char ch1 = this.convert(ch);
                int x = -1;
                for (char ch2 : this.rawShape.toCharArray()) {
                    if (++x >= this.inv.getSize() || ch1 != ch2) continue;
                    this.setItem(ch, new ItemStack(Material.AIR));
                }
                this.slots.remove(Character.valueOf(ch1));
            }
        }
        return this;
    }

    public GUIInventory clear() {
        int x = -1;
        for (char ch : this.rawShape.toCharArray()) {
            if (++x >= this.inv.getSize() || !this.slots.containsKey(Character.valueOf(ch))) continue;
            this.setItem(ch, new ItemStack(Material.AIR));
        }
        this.slots.clear();
        return this;
    }

    public GUIInventory onClose(Consumer<InventoryCloseEvent> run) {
        this.onClose = run;
        return this;
    }

    public Consumer<InventoryCloseEvent> getOnClose() {
        return this.onClose;
    }

    public boolean hasOnClose() {
        return this.onClose != null;
    }

    public Inventory getInventory() {
        if (!this.getListener().isStarted()) {
            this.getListener().start();
            int x = 0;
            for (char ch : this.rawShape.toCharArray()) {
                ItemStack item = this.items.get(Character.valueOf(ch));
                if (item != null && item.getType() != Material.AIR) {
                    this.inv.setItem(x, item);
                }
                ++x;
            }
            this.items.clear();
        }
        return this.inv;
    }

    public GUIListener getListener() {
        if (this.listener == null) {
            this.listener = new GUIListener(this);
        }
        return this.listener;
    }

    public char convertSlot(int slot) {
        if (slot < this.rawShape.length()) {
            return this.rawShape.charAt(slot);
        }
        return ' ';
    }

    public char convertSlot(String rawShape, int slot) {
        if (slot < rawShape.length()) {
            return rawShape.charAt(slot);
        }
        return ' ';
    }

    public char nextInvertedSlot() {
        for (char ch2 : this.rawShape.toCharArray()) {
            if (!this.slots.containsKey(Character.valueOf(ch2))) continue;
            return ch2;
        }
        return '\u0000';
    }

    public char nextSlot() {
        for (char ch2 : this.rawShape.toCharArray()) {
            if (this.slots.containsKey(Character.valueOf(ch2))) continue;
            return ch2;
        }
        return '\u0000';
    }

    private char convert(Object slot) {
        char ch = slot instanceof Number ? this.convertSlot(((Number)slot).intValue()) : (slot instanceof String && !((String)slot).isEmpty() ? ((String)slot).charAt(0) : (slot instanceof Character ? ((Character)slot).charValue() : this.nextSlot()));
        return ch;
    }
}

