/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.tuke.sktuke.util.Registry;
import org.bukkit.entity.Creature;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;

public class CondIsMobType
extends Condition {
    private Expression<LivingEntity> et;
    private MobType mt;

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.et = arg[0];
        this.mt = MobType.values()[arg3.mark];
        this.setNegated(arg1 == 1);
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.et + " is " + this.mt.name().toLowerCase();
    }

    public boolean check(Event e) {
        return this.et.check(e, le -> le instanceof Creature && this.isMobType((Creature)le, this.mt), this.isNegated());
    }

    public boolean isMobType(Creature et, MobType mt) {
        switch (mt) {
            case PASSIVE: {
                switch (et.getType()) {
                    case WOLF: {
                        if (et instanceof Tameable) {
                            return ((Tameable)et).isTamed();
                        }
                    }
                    case OCELOT: 
                    case HORSE: 
                    case SQUID: 
                    case VILLAGER: 
                    case COW: 
                    case PIG: 
                    case CHICKEN: 
                    case SHEEP: 
                    case BAT: 
                    case MUSHROOM_COW: {
                        return true;
                    }
                }
                return et.getType().name().equalsIgnoreCase("RABBIT");
            }
            case NEUTRAL: {
                switch (et.getType()) {
                    case WOLF: {
                        return !((Tameable)et).isTamed();
                    }
                    case CAVE_SPIDER: 
                    case SPIDER: 
                    case ENDERMAN: 
                    case PIG_ZOMBIE: 
                    case PLAYER: {
                        return true;
                    }
                }
                return et.getType().name().equalsIgnoreCase("POLAR_BEAR");
            }
            case HOSTILE: {
                if (this.isMobType(et, MobType.NEUTRAL)) {
                    switch (et.getType()) {
                        case WOLF: {
                            return et.getTarget() != null && !((Tameable)et).isTamed();
                        }
                        case CAVE_SPIDER: 
                        case SPIDER: {
                            return et.getTarget() != null || et.getLocation().getBlock().getLightLevel() <= 10;
                        }
                        case ENDERMAN: 
                        case PIG_ZOMBIE: {
                            return et.getTarget() != null;
                        }
                    }
                    return et.getType().name().equalsIgnoreCase("POLAR_BEAR") && et.getTarget() != null;
                }
                return !this.isMobType(et, MobType.PASSIVE);
            }
        }
        return false;
    }

    static {
        Registry.newCondition(CondIsMobType.class, "%livingentities% (is|are) [a] (0\u00a6hostile|1\u00a6neutral|2\u00a6passive) [mob]", "%livingentities% (is|are)(n't| not) [a] (0\u00a6hostile|1\u00a6neutral|2\u00a6passive) [mob]");
    }

    public static enum MobType {
        HOSTILE,
        NEUTRAL,
        PASSIVE;

    }
}

