/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static void minimize(Automaton a) {
        if (!a.isSingleton()) {
            switch (Automaton.minimization) {
                case 0: {
                    MinimizationOperations.minimizeHuffman(a);
                    break;
                }
                case 1: {
                    MinimizationOperations.minimizeBrzozowski(a);
                    break;
                }
                default: {
                    MinimizationOperations.minimizeHopcroft(a);
                }
            }
        }
        a.recomputeHashCode();
    }

    private static boolean statesAgree(Transition[][] transitions, boolean[][] mark, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1].max < t2[k2].min) {
                ++k1;
                continue;
            }
            if (t2[k2].max < t1[k1].min) {
                ++k2;
                continue;
            }
            int m1 = t1[k1].to.number;
            int m2 = t2[k2].to.number;
            if (m1 > m2) {
                int t = m1;
                m1 = m2;
                m2 = t;
            }
            if (mark[m1][m2]) {
                return false;
            }
            if (t1[k1].max < t2[k2].max) {
                ++k1;
                continue;
            }
            ++k2;
        }
        return true;
    }

    private static void addTriggers(Transition[][] transitions, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1].max < t2[k2].min) {
                ++k1;
                continue;
            }
            if (t2[k2].max < t1[k1].min) {
                ++k2;
                continue;
            }
            if (t1[k1].to != t2[k2].to) {
                int m1 = t1[k1].to.number;
                int m2 = t2[k2].to.number;
                if (m1 > m2) {
                    int t = m1;
                    m1 = m2;
                    m2 = t;
                }
                if (triggers.get(m1).get(m2) == null) {
                    triggers.get(m1).set(m2, new HashSet());
                }
                triggers.get(m1).get(m2).add(new IntPair(n1, n2));
            }
            if (t1[k1].max < t2[k2].max) {
                ++k1;
                continue;
            }
            ++k2;
        }
    }

    private static void markPair(boolean[][] mark, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        mark[n1][n2] = true;
        if (triggers.get(n1).get(n2) != null) {
            for (IntPair p : triggers.get(n1).get(n2)) {
                int m1 = p.n1;
                int m2 = p.n2;
                if (m1 > m2) {
                    int t = m1;
                    m1 = m2;
                    m2 = t;
                }
                if (mark[m1][m2]) continue;
                MinimizationOperations.markPair(mark, triggers, m1, m2);
            }
        }
    }

    private static <T> void initialize(ArrayList<T> list, int size) {
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
    }

    public static void minimizeHuffman(Automaton a) {
        int n;
        int n1;
        a.determinize();
        a.totalize();
        Set<State> ss = a.getStates();
        Transition[][] transitions = new Transition[ss.size()][];
        State[] states = ss.toArray(new State[ss.size()]);
        boolean[][] mark = new boolean[states.length][states.length];
        ArrayList<ArrayList<HashSet<IntPair>>> triggers = new ArrayList<ArrayList<HashSet<IntPair>>>();
        for (n1 = 0; n1 < states.length; ++n1) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, states.length);
            triggers.add(v);
        }
        for (n1 = 0; n1 < states.length; ++n1) {
            states[n1].number = n1;
            transitions[n1] = states[n1].getSortedTransitionArray(false);
            for (int n2 = n1 + 1; n2 < states.length; ++n2) {
                if (states[n1].accept == states[n2].accept) continue;
                mark[n1][n2] = true;
            }
        }
        for (n1 = 0; n1 < states.length; ++n1) {
            for (int n2 = n1 + 1; n2 < states.length; ++n2) {
                if (mark[n1][n2]) continue;
                if (MinimizationOperations.statesAgree(transitions, mark, n1, n2)) {
                    MinimizationOperations.addTriggers(transitions, triggers, n1, n2);
                    continue;
                }
                MinimizationOperations.markPair(mark, triggers, n1, n2);
            }
        }
        int numclasses = 0;
        for (int n2 = 0; n2 < states.length; ++n2) {
            states[n2].number = -1;
        }
        for (int n12 = 0; n12 < states.length; ++n12) {
            if (states[n12].number != -1) continue;
            states[n12].number = numclasses;
            for (int n2 = n12 + 1; n2 < states.length; ++n2) {
                if (mark[n12][n2]) continue;
                states[n2].number = numclasses;
            }
            ++numclasses;
        }
        State[] newstates = new State[numclasses];
        for (n = 0; n < numclasses; ++n) {
            newstates[n] = new State();
        }
        for (n = 0; n < states.length; ++n) {
            newstates[states[n].number].number = n;
            if (states[n] != a.initial) continue;
            a.initial = newstates[states[n].number];
        }
        for (n = 0; n < numclasses; ++n) {
            State s = newstates[n];
            s.accept = states[s.number].accept;
            for (Transition t : states[s.number].transitions) {
                s.transitions.add(new Transition(t.min, t.max, newstates[t.to.number]));
            }
        }
        a.removeDeadTransitions();
    }

    public static void minimizeBrzozowski(Automaton a) {
        if (a.isSingleton()) {
            return;
        }
        BasicOperations.determinize(a, SpecialOperations.reverse(a));
        BasicOperations.determinize(a, SpecialOperations.reverse(a));
    }

    public static void minimizeHopcroft(Automaton a) {
        int n;
        int q;
        a.determinize();
        Set<Transition> tr = a.initial.getTransitions();
        if (tr.size() == 1) {
            Transition t = tr.iterator().next();
            if (t.to == a.initial && t.min == '\u0000' && t.max == '\uffff') {
                return;
            }
        }
        a.totalize();
        Set<State> ss = a.getStates();
        State[] states = new State[ss.size()];
        int number = 0;
        Iterator<State> iterator = ss.iterator();
        while (iterator.hasNext()) {
            State q2;
            states[number] = q2 = iterator.next();
            q2.number = number++;
        }
        char[] sigma = a.getStartPoints();
        ArrayList reverse = new ArrayList();
        for (int q3 = 0; q3 < states.length; ++q3) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, sigma.length);
            reverse.add(v);
        }
        boolean[][] reverse_nonempty = new boolean[states.length][sigma.length];
        ArrayList partition = new ArrayList();
        MinimizationOperations.initialize(partition, states.length);
        int[] block = new int[states.length];
        StateList[][] active = new StateList[states.length][sigma.length];
        StateListNode[][] active2 = new StateListNode[states.length][sigma.length];
        LinkedList<IntPair> pending = new LinkedList<IntPair>();
        boolean[][] pending2 = new boolean[sigma.length][states.length];
        ArrayList<State> split = new ArrayList<State>();
        boolean[] split2 = new boolean[states.length];
        ArrayList<Integer> refine = new ArrayList<Integer>();
        boolean[] refine2 = new boolean[states.length];
        ArrayList splitblock = new ArrayList();
        MinimizationOperations.initialize(splitblock, states.length);
        for (q = 0; q < states.length; ++q) {
            splitblock.set(q, new ArrayList());
            partition.set(q, new LinkedList());
            for (int x = 0; x < sigma.length; ++x) {
                ((ArrayList)reverse.get(q)).set(x, new LinkedList());
                active[q][x] = new StateList();
            }
        }
        for (q = 0; q < states.length; ++q) {
            State qq = states[q];
            int j = qq.accept ? 0 : 1;
            ((LinkedList)partition.get(j)).add(qq);
            block[qq.number] = j;
            for (int x = 0; x < sigma.length; ++x) {
                char y = sigma[x];
                State p = qq.step(y);
                ((LinkedList)((ArrayList)reverse.get(p.number)).get(x)).add(qq);
                reverse_nonempty[p.number][x] = true;
            }
        }
        for (int j = 0; j <= 1; ++j) {
            for (int x = 0; x < sigma.length; ++x) {
                for (State qq : (LinkedList)partition.get(j)) {
                    if (!reverse_nonempty[qq.number][x]) continue;
                    active2[qq.number][x] = active[j][x].add(qq);
                }
            }
        }
        for (int x = 0; x < sigma.length; ++x) {
            int a0 = active[0][x].size;
            int a1 = active[1][x].size;
            int j = a0 <= a1 ? 0 : 1;
            pending.add(new IntPair(j, x));
            pending2[x][j] = true;
        }
        int k = 2;
        while (!pending.isEmpty()) {
            IntPair ip = (IntPair)pending.removeFirst();
            int p = ip.n1;
            int x = ip.n2;
            pending2[x][p] = false;
            StateListNode m = active[p][x].first;
            while (m != null) {
                for (State s : (LinkedList)((ArrayList)reverse.get(m.q.number)).get(x)) {
                    if (split2[s.number]) continue;
                    split2[s.number] = true;
                    split.add(s);
                    int j = block[s.number];
                    ((ArrayList)splitblock.get(j)).add(s);
                    if (refine2[j]) continue;
                    refine2[j] = true;
                    refine.add(j);
                }
                m = m.next;
            }
            Iterator iterator2 = refine.iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                if (((ArrayList)splitblock.get(j)).size() < ((LinkedList)partition.get(j)).size()) {
                    LinkedList b1 = (LinkedList)partition.get(j);
                    LinkedList b2 = (LinkedList)partition.get(k);
                    for (State s : (ArrayList)splitblock.get(j)) {
                        b1.remove(s);
                        b2.add(s);
                        block[s.number] = k;
                        for (int c = 0; c < sigma.length; ++c) {
                            StateListNode sn = active2[s.number][c];
                            if (sn == null || sn.sl != active[j][c]) continue;
                            sn.remove();
                            active2[s.number][c] = active[k][c].add(s);
                        }
                    }
                    for (int c = 0; c < sigma.length; ++c) {
                        int aj = active[j][c].size;
                        int ak = active[k][c].size;
                        if (!pending2[c][j] && 0 < aj && aj <= ak) {
                            pending2[c][j] = true;
                            pending.add(new IntPair(j, c));
                            continue;
                        }
                        pending2[c][k] = true;
                        pending.add(new IntPair(k, c));
                    }
                    ++k;
                }
                for (State s : (ArrayList)splitblock.get(j)) {
                    split2[s.number] = false;
                }
                refine2[j] = false;
                ((ArrayList)splitblock.get(j)).clear();
            }
            split.clear();
            refine.clear();
        }
        State[] newstates = new State[k];
        for (n = 0; n < newstates.length; ++n) {
            State s;
            newstates[n] = s = new State();
            for (State q4 : (LinkedList)partition.get(n)) {
                if (q4 == a.initial) {
                    a.initial = s;
                }
                s.accept = q4.accept;
                s.number = q4.number;
                q4.number = n;
            }
        }
        for (n = 0; n < newstates.length; ++n) {
            State s = newstates[n];
            s.accept = states[s.number].accept;
            for (Transition t : states[s.number].transitions) {
                s.transitions.add(new Transition(t.min, t.max, newstates[t.to.number]));
            }
        }
        a.removeDeadTransitions();
    }

    static class StateListNode {
        State q;
        StateListNode next;
        StateListNode prev;
        StateList sl;

        StateListNode(State q, StateList sl) {
            this.q = q;
            this.sl = sl;
            if (sl.size++ == 0) {
                sl.first = sl.last = this;
            } else {
                sl.last.next = this;
                this.prev = sl.last;
                sl.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }

    static class StateList {
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(State q) {
            return new StateListNode(q, this);
        }
    }

    static class IntPair {
        int n1;
        int n2;

        IntPair(int n1, int n2) {
            this.n1 = n1;
            this.n2 = n2;
        }
    }
}

