/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.util;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.EnumUtils;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import me.tuke.sktuke.TuSKe;

public class EnumType
extends ClassInfo {
    public <T extends Enum<T>> EnumType(Class<T> c, String code, String regexUser) {
        this(c, code, regexUser, code);
    }

    public <T extends Enum<T>> EnumType(Class<T> c, String code, String regexUser, String languageNode) {
        super(c, code);
        EnumUtils enumUtils = new EnumUtils(c, languageNode);
        String names = enumUtils.getAllNames();
        if (names != null && !names.isEmpty()) {
            this.usage(new String[]{enumUtils.getAllNames()});
        } else {
            this.usage(new String[]{EnumType.getAllNames(c)});
        }
        Parser<T> parser = this.getParser(c, enumUtils);
        try {
            Classes.registerClass((ClassInfo)this.user(new String[]{regexUser}).defaultExpression((DefaultExpression)new EventValueExpression(c)).parser(parser));
        }
        catch (Exception e) {
            TuSKe.debug("Couldn't register the type '" + code + "'. Due to: " + (e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : "unknown"));
        }
    }

    private <T extends Enum<T>> Parser<T> getParser(final Class<T> c, final EnumUtils<T> enumUtils) {
        if (!TuSKe.getInstance().getConfig().getBoolean("use_only_enum_names")) {
            return new Parser<T>(){

                @Nullable
                public T parse(String name, ParseContext arg1) {
                    Enum result;
                    if ((name = EnumType.fromString(name)).startsWith(c.getSimpleName().toUpperCase() + ".")) {
                        name = name.split("\\.")[1];
                    }
                    if ((result = enumUtils.parse(name)) != null) {
                        return result;
                    }
                    try {
                        return Enum.valueOf(c, name);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                public String toString(T e, int arg1) {
                    return EnumType.toString(e);
                }

                public String toVariableNameString(T e) {
                    return c.getSimpleName() + "." + ((Enum)e).name();
                }

                public String getVariableNamePattern() {
                    return "(" + c.getSimpleName().toLowerCase() + "\\.)?.+";
                }
            };
        }
        return new Parser<T>(){

            @Nullable
            public T parse(String name, ParseContext arg1) {
                if ((name = EnumType.fromString(name)).startsWith(c.getSimpleName().toUpperCase() + ".")) {
                    Enum result = enumUtils.parse(name = name.split("\\.")[1]);
                    if (result != null) {
                        return result;
                    }
                    try {
                        return Enum.valueOf(c, name);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }

            public String toString(T e, int arg1) {
                return EnumType.toString(e);
            }

            public String toVariableNameString(T e) {
                return c.getSimpleName() + "." + ((Enum)e).name();
            }

            public String getVariableNamePattern() {
                return "(" + c.getSimpleName().toLowerCase() + "\\.)?.+";
            }
        };
    }

    public static String getAllNames(Class<? extends Enum> enumClz) {
        StringJoiner sj = new StringJoiner(", ");
        for (Enum e : enumClz.getEnumConstants()) {
            sj.add(EnumType.toString(e));
        }
        return sj.toString();
    }

    public static String toString(Enum<?> e) {
        return e.name().toLowerCase().replaceAll("_", " ");
    }

    public static String fromString(String str) {
        return str.toUpperCase().replaceAll("\\s+", "_");
    }
}

