/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.listeners;

import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.manager.gui.GUI;
import me.tuke.sktuke.manager.gui.GUIActionEvent;
import me.tuke.sktuke.manager.gui.GUIManager;
import me.tuke.sktuke.util.InventoryUtils;
import me.tuke.sktuke.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;

public class InventoryCheck
implements Listener {
    private TuSKe instance;
    private GUIManager gm;

    public InventoryCheck(TuSKe tuske, GUIManager manager) {
        this.instance = tuske;
        this.gm = manager;
    }

    @EventHandler
    public void onClick(final InventoryClickEvent e) {
        if (this.getClickedInventory(e) != null && this.gm.isAllowedType(e.getClick()) && (this.gm.hasGUI(this.getClickedInventory(e)) || this.gm.hasGUI(e.getInventory()))) {
            Inventory click;
            Inventory inv = click = this.getClickedInventory(e);
            Integer slot = e.getSlot();
            if (e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) && !inv.getType().equals((Object)e.getInventory().getType()) || e.getAction().equals((Object)InventoryAction.COLLECT_TO_CURSOR)) {
                inv = e.getInventory();
                ItemStack i = e.getAction().equals((Object)InventoryAction.COLLECT_TO_CURSOR) ? e.getCursor() : click.getItem(e.getSlot());
                slot = InventoryUtils.getSlotTo(inv, i);
            }
            if (this.gm.isGUI(inv, slot)) {
                e.setCancelled(true);
                final GUI gui = this.gm.getGUI(click, e.getSlot(), e.getClick());
                if (gui != null && e.getInventory().getItem(e.getSlot()) != null && gui.runOnlyWith(e.getCursor())) {
                    if (gui.toCallEvent()) {
                        GUIActionEvent guie = new GUIActionEvent(e);
                        Bukkit.getPluginManager().callEvent((Event)guie);
                        e.setCancelled(!guie.isCancelled());
                    } else if (gui.toClose()) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.instance, new Runnable(){

                            @Override
                            public void run() {
                                if (gui.getInventory() != null) {
                                    e.getWhoClicked().openInventory(gui.getInventory());
                                } else {
                                    e.getWhoClicked().closeInventory();
                                }
                                if (gui.toRun()) {
                                    gui.run((Event)e);
                                }
                            }
                        }, 0L);
                    } else if (gui.toRun()) {
                        gui.run((Event)e);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onClose(final InventoryCloseEvent e) {
        if (this.gm.hasGUI(e.getInventory())) {
            this.gm.removeAll(e.getInventory());
            Bukkit.getScheduler().runTaskLater((Plugin)this.instance, new Runnable(){

                @Override
                public void run() {
                    ((Player)e.getPlayer()).updateInventory();
                }
            }, 0L);
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        if (e.getInventory() != null && e.getInventorySlots() != null && e.getInventorySlots().size() > 0 && e.getWhoClicked() instanceof Player) {
            for (Integer slot : e.getInventorySlots()) {
                if (slot >= e.getInventory().getSize() || !this.gm.isGUI(e.getInventory(), e.getView().convertSlot(slot.intValue()))) continue;
                e.setCancelled(true);
                return;
            }
        }
    }

    private boolean isAllowedTo(Inventory inv, ItemStack i, int slot) {
        switch (inv.getType()) {
            case ANVIL: {
                return slot < 2;
            }
            case BEACON: {
                return i.getType().equals((Object)Material.DIAMOND) || i.getType().equals((Object)Material.IRON_INGOT) || i.getType().equals((Object)Material.GOLD_INGOT) || i.getType().equals((Object)Material.EMERALD);
            }
            case BREWING: {
                return i.getItemMeta() instanceof PotionMeta;
            }
        }
        return true;
    }

    private Inventory getClickedInventory(InventoryClickEvent e) {
        if (ReflectionUtils.hasMethod(InventoryClickEvent.class, "getClickedInventory", new Class[0])) {
            return e.getClickedInventory();
        }
        if (e.getRawSlot() < 0) {
            return null;
        }
        if (e.getView().getTopInventory() != null && e.getRawSlot() < e.getView().getTopInventory().getSize()) {
            return e.getView().getTopInventory();
        }
        return e.getView().getBottomInventory();
    }
}

