/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.documentation;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.tuke.sktuke.documentation.SyntaxInfo;
import me.tuke.sktuke.util.EffectSection;
import me.tuke.sktuke.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Documentation
implements Runnable {
    private Map<String, Map<String, List<SyntaxInfo>>> docs = new HashMap<String, Map<String, List<SyntaxInfo>>>();
    private Map<String, String> addons = new HashMap<String, String>();
    private Class<?>[] types;
    private JavaPlugin instance;

    public Documentation(JavaPlugin plugin) {
        this.instance = plugin;
    }

    public void load() {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.instance, (Runnable)this, 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.instance.getLogger().info("Generating documentation of Skript & Addons.");
        HashMap type = new HashMap();
        type.put("Types", new ArrayList());
        this.docs.put("Types", type);
        for (Object addon : Skript.getAddons()) {
            this.addons.put(((SkriptAddon)addon).plugin.getClass().getPackage().getName(), addon.getName());
        }
        int x = 0;
        this.types = new Class[Classes.getClassInfos().size()];
        for (ClassInfo classInfo : Classes.getClassInfos()) {
            if (x >= this.types.length) continue;
            this.types[x++] = classInfo.getC();
        }
        this.addons.put(Skript.class.getPackage().getName(), "Skript");
        for (String string : this.addons.values()) {
            HashMap syntaxes = new HashMap();
            syntaxes.put("Events", new ArrayList());
            syntaxes.put("Conditions", new ArrayList());
            syntaxes.put("Effects", new ArrayList());
            syntaxes.put("Expressions", new ArrayList());
            this.docs.put(string, syntaxes);
        }
        ParseLogHandler h = SkriptLogger.startParseLogHandler();
        try {
            for (SkriptEventInfo event : Skript.getEvents()) {
                this.addEventSyntaxInfo(event);
            }
            for (SyntaxElementInfo condition : Skript.getConditions()) {
                this.addSyntaxInfo("Conditions", condition.c, condition.patterns);
            }
            for (SyntaxElementInfo effect : Skript.getEffects()) {
                this.addSyntaxInfo("Effects", effect.c, effect.patterns);
            }
            Iterator iterator = Skript.getExpressions();
            while (iterator.hasNext()) {
                ExpressionInfo expr = (ExpressionInfo)iterator.next();
                this.addSyntaxInfo("Expressions", expr.c, expr.returnType, expr.patterns);
            }
        }
        finally {
            h.clear();
            h.stop();
        }
        for (ClassInfo ci : Classes.getClassInfos()) {
            this.addTypeSyntaxInfo(ci);
        }
        File file = new File(this.instance.getDataFolder(), "documentation/");
        if (!file.exists()) {
            file.mkdirs();
        }
        for (Map.Entry<String, Map<String, List<SyntaxInfo>>> entry : this.docs.entrySet()) {
            try {
                File addonFile = new File(file, entry.getKey() + ".sk");
                if (!addonFile.exists()) {
                    addonFile.createNewFile();
                }
                BufferedWriter bf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(addonFile), "UTF-8"));
                String toWrite = "";
                if (entry.getKey().equals("TuSKeTypes")) {
                    toWrite = toWrite + "#All Skript and Addons types.\n#Each type has an pattern of how it should\n#Be used in command arguments or 'parsed as %type%'.\n#Also, some values contains its default values,\n#but they may have different values when using in scripts.\n\n";
                }
                for (Map.Entry<String, List<SyntaxInfo>> entry2 : entry.getValue().entrySet()) {
                    if (entry2.getValue().size() == 0) continue;
                    toWrite = toWrite + entry2.getKey() + ":\n";
                    for (SyntaxInfo s : entry2.getValue()) {
                        toWrite = toWrite + s.toString();
                    }
                }
                bf.write(toWrite);
                bf.flush();
                bf.close();
            }
            catch (Exception e) {
                this.instance.getLogger().severe("A error occurred while creating documentation of '" + entry.getKey() + "':");
                e.printStackTrace();
                return;
            }
        }
        this.instance.getLogger().info("Documentation was generated successfully.");
    }

    public void addSyntaxInfo(String type, Class<?> c, String ... syntaxes) {
        this.addSyntaxInfo(type, c, (Class<?>)null, syntaxes);
    }

    public void addSyntaxInfo(String type, Class<?> c, Class<?> returnType, String ... syntaxes) {
        String addonOwner = null;
        String pack = c.getPackage().getName();
        for (Map.Entry<String, String> entry : this.addons.entrySet()) {
            if (!pack.startsWith(entry.getKey())) continue;
            addonOwner = entry.getValue();
            break;
        }
        if (addonOwner == null) {
            addonOwner = "Skript";
        }
        SyntaxInfo si = this.getSyntaxInfo(c, syntaxes);
        if (returnType != null) {
            ArrayList<String> changers = new ArrayList<String>();
            Expression i = (Expression)ReflectionUtils.newInstance(c);
            for (Changer.ChangeMode mode : Changer.ChangeMode.values()) {
                try {
                    if (!Changer.ChangerUtils.acceptsChange((Expression)i, (Changer.ChangeMode)mode, (Class[])this.types)) continue;
                    changers.add(mode.name().toLowerCase().replaceAll("_", " "));
                }
                catch (Exception e) {
                    changers.add("unknown");
                    break;
                }
            }
            if (changers.size() == 0) {
                changers.add("none");
            }
            si.addValue("\t\tChangers: " + this.arrayToString(changers.toArray(new String[changers.size()])));
            ClassInfo ci = Classes.getExactClassInfo(returnType);
            if (ci != null) {
                si.addValue("\t\tReturns: " + (ci.getDocName() != null && !ci.getDocName().isEmpty() ? ci.getDocName() : ci.getCodeName()));
            }
        }
        if (EffectSection.class.isAssignableFrom(c)) {
            type = "Effects";
        }
        this.docs.get(addonOwner).get(type).add(si);
    }

    private void addEventSyntaxInfo(SkriptEventInfo<?> sei) {
        String addonOwner = null;
        String pack = sei.c.getPackage().getName();
        for (Map.Entry<String, String> entry : this.addons.entrySet()) {
            if (!pack.startsWith(entry.getKey())) continue;
            addonOwner = entry.getValue();
            break;
        }
        if (addonOwner == null) {
            addonOwner = "Skript";
        }
        SyntaxInfo s = new SyntaxInfo();
        s.addValue("\t" + sei.name + ":");
        ArrayList<String> events = new ArrayList<String>();
        events.add("\t\tEvent values:");
        events.addAll(this.getEventValues(-1, "past event", sei.events));
        events.addAll(this.getEventValues(0, "event", sei.events));
        events.addAll(this.getEventValues(1, "future event", sei.events));
        s.getValues().addAll(this.fromArray(events.size() > 1 ? "Patterns" : null, sei.patterns));
        if (events.size() > 1) {
            s.getValues().addAll(events);
        }
        this.docs.get(addonOwner).get("Events").add(s);
    }

    private void addTypeSyntaxInfo(ClassInfo<?> ci) {
        SyntaxInfo s = new SyntaxInfo();
        s.addValue(" ");
        if (ci.getDocName() != null) {
            if (ci.getDocName().isEmpty()) {
                return;
            }
            s.addValue("\t" + ci.getDocName().toLowerCase() + ":" + (ci.getUserInputPatterns() != null && ci.getUserInputPatterns().length == 1 ? " " + ci.getUserInputPatterns()[0].pattern().replaceAll("\\((.+?)\\)\\?", "[$1]").replaceAll("(.)\\?", "[$1]") : ""));
        } else if (!ci.getCodeName().isEmpty()) {
            s.addValue("\t" + ci.getCodeName() + ":" + (ci.getUserInputPatterns() != null && ci.getUserInputPatterns().length == 1 ? " " + ci.getUserInputPatterns()[0].pattern().replaceAll("\\((.+?)\\)\\?", "[$1]").replaceAll("(.)\\?", "[$1]") : ""));
        }
        if (ci.getUserInputPatterns() != null && ci.getUserInputPatterns().length > 1) {
            String indentation;
            String string = indentation = ci.getC().isEnum() ? "\t" : "";
            if (indentation.equals("\t")) {
                s.addValue("\t\tPatterns:");
            }
            for (Pattern pattern : ci.getUserInputPatterns()) {
                s.addValue(indentation + "\t\t" + pattern.pattern().replaceAll("\\((.+?)\\)\\?", "[$1]").replaceAll("(.)\\?", "[$1]"));
            }
        }
        if (ci.getC().isEnum()) {
            if (ci.getUsage() == null || ci.getUsage().length == 0) {
                ArrayList<String> values = new ArrayList<String>();
                for (Object t : ci.getC().getEnumConstants()) {
                    values.add(t.toString().replaceAll("_", " ").toLowerCase());
                }
                s.addValue("\t\tValues: " + this.arrayToString(values.toArray(new String[values.size()])));
            } else {
                s.addValue("\t\tValues: " + this.arrayToString(ci.getUsage()));
            }
        }
        this.docs.get("Types").get("Types").add(s);
    }

    private SyntaxInfo getSyntaxInfo(Class<?> c, String ... syntaxes) {
        ArrayList<String> list = new ArrayList<String>();
        if (c.isAnnotationPresent(Name.class)) {
            list.add("\t" + c.getAnnotation(Name.class).value() + ":");
        } else {
            list.add("\t" + c.getSimpleName() + ":");
        }
        if (syntaxes.length > 0) {
            list.addAll(this.fromArray(Expression.class.isAssignableFrom(c) ? "Patterns" : null, syntaxes));
        }
        SyntaxInfo s = new SyntaxInfo();
        s.getValues().addAll(list);
        return s;
    }

    private List<String> getEventValues(int time, String prefix, Class<? extends Event> ... classes) {
        ArrayList<String> events = new ArrayList<String>();
        for (Class c : this.getEventValues(time, classes)) {
            ClassInfo ci = Classes.getExactClassInfo((Class)c);
            if (ci == null) continue;
            events.add("\t\t\t" + prefix + "-" + ci.getCodeName());
        }
        return events;
    }

    private Class[] getEventValues(int time, Class<? extends Event> ... classes) {
        HashSet<Class> classs = new HashSet<Class>();
        Method m = ReflectionUtils.getMethod(EventValues.class, "getEventValuesList", Integer.TYPE);
        List values = (List)ReflectionUtils.invokeMethod(m, null, time);
        if (values != null) {
            for (Class<? extends Event> c : classes) {
                for (Object eventValue : values) {
                    Class ret;
                    Class event = (Class)ReflectionUtils.getField(eventValue.getClass(), eventValue, "event");
                    if (event == null || !c.isAssignableFrom(event) && !event.isAssignableFrom(c) || (ret = (Class)ReflectionUtils.getField(eventValue.getClass(), eventValue, "c")) == null) continue;
                    classs.add(ret);
                }
            }
        }
        return classs.toArray(new Class[classs.size()]);
    }

    private List<String> fromArray(String value, String ... values) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null) {
            result.add("\t\t" + value + ":");
        }
        for (int x = 0; x < values.length; ++x) {
            result.add((value != null ? "\t" : "") + "\t\t" + values[x]);
        }
        return result;
    }

    private String arrayToString(String ... values) {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < values.length; ++x) {
            if (x > 0) {
                if (x == values.length - 1) {
                    sb.append(" and ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append(values[x]);
        }
        return sb.toString();
    }
}

