/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.conditions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;

public class CondCanSpawn
extends Condition {
    private Expression<?> loc;
    private Expression<EntityType> ent;
    private int isMonsters;

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        if (arg1 == 1 || arg1 == 3) {
            if (ScriptLoader.isCurrentEvent((Class[])new Class[]{CreatureSpawnEvent.class, ItemSpawnEvent.class, SpawnerSpawnEvent.class})) {
                Skript.error((String)"You can't use this condition inside a entity spawn event");
                return false;
            }
            this.ent = arg[0];
        }
        this.loc = arg[arg1 > 1 ? arg1 - 2 : arg1];
        this.isMonsters = arg3.mark;
        this.setNegated(arg1 > 1);
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "can spawn at " + this.loc;
    }

    public boolean check(Event e) {
        if (this.loc.getSingle(e) == null || this.isMonsters == 0 && this.ent.getSingle(e) == null) {
            return false;
        }
        Location l = this.loc.getSingle(e) instanceof String ? Bukkit.getWorld((String)((String)this.loc.getSingle(e))).getSpawnLocation() : (this.loc.getSingle(e) instanceof World ? ((World)this.loc.getSingle(e)).getSpawnLocation() : (Location)this.loc.getSingle(e));
        boolean r = false;
        if (this.isMonsters > 0) {
            r = this.isMonsters == 1 ? l.getWorld().getAllowMonsters() : l.getWorld().getAllowAnimals();
        } else {
            Entity en = ((EntityType)this.ent.getSingle((Event)e)).data.spawn(l);
            r = en.isValid();
            if (en.isValid()) {
                en.remove();
            }
        }
        if (this.isNegated()) {
            return !r;
        }
        return r;
    }
}

