/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.util;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.log.HandlerList;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import me.tuke.sktuke.util.ReflectionUtils;
import org.bukkit.event.Event;

public abstract class EffectSection
extends Condition {
    private SectionNode section = null;
    private TriggerSection trigger = null;
    private boolean hasIfOrElseIf = false;

    public EffectSection() {
        Node n = SkriptLogger.getNode();
        if (n != null && n instanceof SectionNode) {
            this.hasIfOrElseIf = StringUtils.startsWithIgnoreCase((String)n.getKey(), (String)"if ") || StringUtils.startsWithIgnoreCase((String)n.getKey(), (String)"else if ");
            String comment = (String)ReflectionUtils.getField(Node.class, n, "comment");
            if (comment == null) {
                comment = "";
            }
            this.section = new SectionNode(n.getKey(), comment, n.getParent(), n.getLine());
            ReflectionUtils.setField(SectionNode.class, this.section, "nodes", ReflectionUtils.getField(SectionNode.class, n, "nodes"));
            ReflectionUtils.setField(SectionNode.class, n, "nodes", new ArrayList());
        }
    }

    protected abstract void execute(Event var1);

    public boolean check(Event e) {
        this.execute(e);
        return !this.hasSection();
    }

    public void loadSection() {
        if (this.section != null) {
            RetainingLogHandler errors = SkriptLogger.startRetainingLog();
            try {
                this.trigger = new TriggerSection(this.section){

                    public String toString(Event event, boolean b) {
                        return EffectSection.this.toString(event, b);
                    }

                    public TriggerItem walk(Event event) {
                        return this.walk(event, true);
                    }
                };
            }
            finally {
                this.stopLog(errors);
            }
            this.section = null;
        }
    }

    public void loadSection(String name, Class<? extends Event> ... events) {
        if (this.section != null && name != null && events != null && events.length > 0) {
            String previousName = ScriptLoader.getCurrentEventName();
            Class[] previousEvents = ScriptLoader.getCurrentEvents();
            Kleenean previousDelay = ScriptLoader.hasDelayBefore;
            ScriptLoader.setCurrentEvent((String)name, (Class[])events);
            this.loadSection();
            ScriptLoader.setCurrentEvent((String)previousName, (Class[])previousEvents);
            ScriptLoader.hasDelayBefore = previousDelay;
        }
    }

    public boolean hasSection() {
        return this.section != null || this.trigger != null;
    }

    protected void runSection(Event e) {
        TriggerItem.walk((TriggerItem)this.trigger, (Event)e);
    }

    public boolean checkIfCondition() {
        if (this.hasIfOrElseIf) {
            Skript.error((String)"You can't use the effect in if/else if section.");
        }
        return this.hasIfOrElseIf;
    }

    public SectionNode getSectionNode() {
        return this.section;
    }

    private void stopLog(RetainingLogHandler logger) {
        LogHandler l;
        logger.stop();
        HandlerList handler = (HandlerList)ReflectionUtils.getField(SkriptLogger.class, null, "handlers");
        if (handler == null) {
            return;
        }
        Iterator it = handler.iterator();
        ArrayList<LogHandler> toStop = new ArrayList<LogHandler>();
        while (it.hasNext() && (l = (LogHandler)it.next()) instanceof ParseLogHandler) {
            toStop.add(l);
        }
        toStop.forEach(LogHandler::stop);
        SkriptLogger.logAll((Collection)logger.getLog());
    }
}

