/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions.regex;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import me.tuke.sktuke.util.Registry;
import org.bukkit.event.Event;

@Name(value="Regex Pattern")
@Description(value={"This expression returns some regex patterns that Skript or Bukkit uses most."})
@Examples(value={"player's uuid regex matches uuid pattern #It will be always true.", "\"{MyVariable}\" regex matches variable pattern", "set {_list::*} to regex split \"%{VariableList::*}%\" with list pattern"})
@Since(value="1.7.5")
public class ExprRegexPattern
extends SimpleExpression<Pattern> {
    public static Map<String, Pattern> patterns = null;
    private Pattern result;

    private void init() {
        if (patterns == null) {
            patterns = new HashMap<String, Pattern>();
            patterns.put("uuid", Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
            patterns.put("variable", Pattern.compile("(?<=^|,)\\s*([^\",]*|\"([^\"]|\"\")*\")\\s*(,|$)"));
            patterns.put("list", SkriptParser.listSplitPattern);
        }
    }

    protected Pattern[] get(Event event) {
        return new Pattern[]{this.result};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Pattern> getReturnType() {
        return Pattern.class;
    }

    public String toString(Event event, boolean b) {
        return null;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.init();
        String name = ((MatchResult)parseResult.regexes.get(0)).group(0).toLowerCase();
        this.result = patterns.get(name);
        if (this.result != null) {
            return true;
        }
        Skript.error((String)("Doesn't exist any regex pattern called '" + name + "'."));
        return false;
    }

    static {
        Registry.newMatchesEverything(ExprRegexPattern.class, "<.+> [regex] pattern");
    }
}

