/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions.recipe;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.util.Registry;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

@Name(value="All Recipes")
@Description(value={"Returns all server recipes. You can get the {{expressions|RecipeIngredients|ingredients}} and the {{expressions|RecipeResult|result item}}."})
@Examples(value={"command /recipes <integer=1>:", "\tusage: /recipes <page>", "\ttrigger:", "\t\tset {_list::*} to page arg of all recipes with 10 lines", "\t\tloop {_list::*}:", "\t\t\tsend \"Ingredients to create %result item of loop-value%: %ingredients of loop-value%\""})
@Since(value="1.6.8, 1.7.5 (recipe type list)")
public class ExprAllRecipes
extends SimpleExpression<Recipe> {
    int type = 0;

    public Class<? extends Recipe> getReturnType() {
        return Recipe.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        if (arg3.expr.toLowerCase().contains("shaped")) {
            this.type = 1;
        } else if (arg3.expr.toLowerCase().contains("shapeless")) {
            this.type = 2;
        } else if (arg3.expr.toLowerCase().contains("furnace")) {
            this.type = 3;
        }
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "all recipes";
    }

    @Nullable
    protected Recipe[] get(Event arg0) {
        ArrayList<Recipe> rec;
        if (this.type == 0) {
            rec = Lists.newArrayList((Iterator)Bukkit.recipeIterator());
        } else {
            Iterator it = Bukkit.recipeIterator();
            rec = new ArrayList<Recipe>();
            while (it.hasNext()) {
                Recipe r = (Recipe)it.next();
                if (!(this.type == 1 && r instanceof ShapedRecipe || this.type == 2 && r instanceof ShapelessRecipe) && (this.type != 3 || !(r instanceof FurnaceRecipe))) continue;
                rec.add(r);
            }
        }
        return rec.toArray(new Recipe[rec.size()]);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        switch (mode) {
            case DELETE: {
                Bukkit.clearRecipes();
                break;
            }
            case RESET: {
                Bukkit.resetRecipes();
                break;
            }
            case REMOVE: {
                TuSKe.getRecipeManager().removeRecipe((Recipe[])delta);
                return;
            }
        }
        TuSKe.getRecipeManager().clearRecipes();
    }

    public Iterator<Recipe> iterator(Event e) {
        if (this.type == 0) {
            return Bukkit.recipeIterator();
        }
        return new Iterator<Recipe>(){
            Iterator<Recipe> recipes = Bukkit.recipeIterator();
            Recipe next;

            @Override
            public boolean hasNext() {
                this.next = null;
                while (this.recipes.hasNext()) {
                    Recipe r = this.recipes.next();
                    if (!(ExprAllRecipes.this.type == 1 && r instanceof ShapedRecipe || ExprAllRecipes.this.type == 2 && r instanceof ShapelessRecipe) && (ExprAllRecipes.this.type != 3 || !(r instanceof FurnaceRecipe))) continue;
                    this.next = r;
                    break;
                }
                return this.next != null;
            }

            @Override
            public Recipe next() {
                return this.next;
            }
        };
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Recipe[].class});
        }
        return null;
    }

    static {
        Registry.newSimple(ExprAllRecipes.class, "[all] [registred] (shaped|shapeless|furnace|) recipes");
    }
}

