/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions.customenchantments;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.tuke.sktuke.manager.customenchantment.CEnchant;
import me.tuke.sktuke.manager.customenchantment.EnchantConfig;
import me.tuke.sktuke.util.Registry;
import org.bukkit.event.Event;

public class ExprMaxLevel
extends SimplePropertyExpression<CEnchant, Number> {
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Nullable
    public Number convert(CEnchant ce) {
        return ce.getEnchant().getMaxLevel();
    }

    protected String getPropertyName() {
        return "max level";
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        CEnchant ce = (CEnchant)this.getExpr().getSingle(e);
        if (mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET && delta == null) {
            return;
        }
        if (ce != null) {
            int value = ce.getEnchant().getMaxLevel();
            switch (mode) {
                case SET: {
                    value = ((Number)delta[0]).intValue();
                    break;
                }
                case ADD: {
                    value += ((Number)delta[0]).intValue();
                    break;
                }
                case REMOVE: {
                    value -= ((Number)delta[0]).intValue();
                    break;
                }
            }
            if (value < 1) {
                value = 1;
            } else if (value > 3999) {
                value = 3999;
            }
            ce.getEnchant().setMaxLevel(value);
            EnchantConfig.y.set("Enchantments." + ce.getEnchant().getId() + ".MaxLevel", (Object)value);
            EnchantConfig.save();
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    static {
        Registry.newProperty(ExprMaxLevel.class, "max level", "customenchantment");
    }
}

