/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions.customenchantments;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Map;
import javax.annotation.Nullable;
import me.tuke.sktuke.manager.customenchantment.CEnchant;
import me.tuke.sktuke.manager.customenchantment.CustomEnchantment;
import me.tuke.sktuke.manager.customenchantment.EnchantManager;
import me.tuke.sktuke.util.Registry;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprAllCustomEnchants
extends SimpleExpression<CEnchant> {
    private Expression<ItemStack> i;

    public Class<? extends CEnchant> getReturnType() {
        return CEnchant.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.i = arg[0];
        return true;
    }

    public String toString(@Nullable Event e, boolean arg1) {
        return "all custom enchantments of " + this.i;
    }

    @Nullable
    protected CEnchant[] get(Event e) {
        ItemStack i = (ItemStack)this.i.getSingle(e);
        if (i != null) {
            Map<CustomEnchantment, Integer> enchs = CustomEnchantment.getCustomEnchants(i);
            CEnchant[] ce = new CEnchant[enchs.size()];
            int x = 0;
            for (CustomEnchantment cce : enchs.keySet()) {
                ce[x] = new CEnchant(cce, enchs.get(cce));
                ++x;
            }
            return ce;
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ItemStack i = (ItemStack)this.i.getSingle(e);
        CEnchant[] ce = null;
        if (mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET && delta != null) {
            ce = (CEnchant[])delta;
        }
        if (i != null) {
            switch (mode) {
                case SET: {
                    for (CustomEnchantment cce : CustomEnchantment.getCustomEnchants(i).keySet()) {
                        EnchantManager.removeFromItem(i, cce);
                    }
                }
                case ADD: {
                    for (CEnchant cce : ce) {
                        EnchantManager.addToItem(i, cce.getEnchant(), cce.getLevel(), true);
                    }
                    break;
                }
                case REMOVE: {
                    for (CEnchant cce : ce) {
                        EnchantManager.removeFromItem(i, cce.getEnchant());
                    }
                    break;
                }
                case DELETE: 
                case RESET: {
                    for (CustomEnchantment cce : CustomEnchantment.getCustomEnchants(i).keySet()) {
                        EnchantManager.removeFromItem(i, cce);
                    }
                    break;
                }
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.DELETE || mode != Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{CEnchant[].class});
        }
        return null;
    }

    static {
        Registry.newProperty(ExprAllCustomEnchants.class, "[all] custom enchantments", "itemstack");
    }
}

