/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import javax.annotation.Nullable;
import me.tuke.sktuke.util.Registry;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import protocolsupport.api.ProtocolSupportAPI;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;

@Name(value="Minecraft Version")
@Description(value={"Returns the minecraft version of {{types|Player|player}}."})
@Examples(value={"on join:", "if minecraft version of player is \"1.9\":", "send \"You're joining with version %mc version of player%!\""})
@Since(value="1.0 (ProtocolSupport), 1.0.5 (ViaVersion)")
public class ExprPlayerVersion
extends SimplePropertyExpression<Player, String> {
    private static final boolean isViaversion = Bukkit.getServer().getPluginManager().isPluginEnabled("ViaVersion");
    private static final boolean isProtocolSupport = Bukkit.getServer().getPluginManager().isPluginEnabled("ProtocolSupport");

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Nullable
    public String convert(Player p) {
        if (isViaversion) {
            int i = ViaVersion.getInstance().getPlayerVersion(p);
            return ProtocolVersion.getProtocol((int)i).getName().replace(".x", "");
        }
        if (isProtocolSupport) {
            return ProtocolSupportAPI.getProtocolVersion((Player)p).getName();
        }
        return null;
    }

    protected String getPropertyName() {
        return "minecraft version";
    }

    static {
        if (isViaversion || isProtocolSupport) {
            Registry.newProperty(ExprPlayerVersion.class, "(mc|minecraft) version", "player");
        }
    }
}

