/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.tuke.sktuke.util.Registry;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ExprExpOf
extends SimplePropertyExpression<Player, Integer> {
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Nullable
    public Integer convert(Player p) {
        return p != null ? Integer.valueOf(this.getExperience(p).intValue()) : null;
    }

    protected String getPropertyName() {
        return "xp";
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Player p = (Player)this.getExpr().getSingle(e);
        if (p != null) {
            Long a = 0L;
            if (delta != null) {
                a = ((Number)delta[0]).longValue();
            }
            if (a >= 0L && (double)a.longValue() <= 2.0E31) {
                switch (mode) {
                    case ADD: {
                        break;
                    }
                    case REMOVE: {
                        a = this.getExperience(p) - a;
                    }
                    default: {
                        p.setExp(0.0f);
                        p.setLevel(0);
                        p.setTotalExperience(0);
                    }
                }
                if (a < 0L) {
                    a = 0L;
                }
                p.giveExp(a.intValue());
                if (mode == Changer.ChangeMode.REMOVE && Long.compare(this.getExperience(p), a) != 0 && a != 0L) {
                    Long b = this.getExperience(p) > a ? this.getExperience(p) - a : a - this.getExperience(p);
                    p.giveExp(-b.intValue());
                }
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    private Long getExperience(Player p) {
        return this.getExpFromLevel(p.getLevel()) + (long)this.getExpFromProg(p.getExpToLevel(), p.getExp());
    }

    private Long getExpFromLevel(int lvl) {
        if (lvl <= 16) {
            return lvl * lvl + 6 * lvl;
        }
        if (lvl <= 31) {
            return (long)(2.5 * (double)(lvl * lvl) - 40.5 * (double)lvl + 360.0);
        }
        return (long)(4.5 * (double)(lvl * lvl) - 162.5 * (double)lvl + 2220.0);
    }

    private int getExpFromProg(int nextLevel, float progress) {
        return Math.round((float)nextLevel * progress);
    }

    static {
        Registry.newProperty(ExprExpOf.class, "[total] [e]xp", "player");
    }
}

