/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import java.io.File;
import java.util.regex.MatchResult;
import me.tuke.sktuke.util.ReflectionUtils;
import me.tuke.sktuke.util.Registry;
import org.bukkit.event.Event;

@Name(value="Evaluate")
@Description(value={"This effect will run any Skript effect/condition from a given string or piece of code. The difference between {{effects|EvaluateInputEffect|SkQuery effect}} and this is basically it returns all syntaxes errors instead of send them to the console, It can evaluate a long amount of code and see them easily instead of beeing in one line. \nFor example, you can run a effect from a string, from a piece of code (without beeing quoted) or the entiry section of code."})
@Examples(value={"set {_effect} to \"send\"", "evaluate:", "\t%{_effect}% \"This message will be sent to a player.\"", "#Before parsing the code, it will convert all variables", "#To string, basically it will interpret the code above as it", "#was a whole string: \"%{_effect}% \"\"This message will be sent to a player.\"\"\"", "#where Skript will replace '%{_effect}%' with the variable value and then it will parse", "#The code. It is the same concept of Skript Options.", " ", "evaluate: kill all players #Not really needed for this but just an example", "evaluate: \"broadcast \"\"Hi everyone\"\"\"", "evaluate:", "\tif true is true:", "\t\tgive a diamond sword of %{Enchantment}% 1 to all players", "evaluate logging in {_errors::*}: this is not a valid effect", "if {_errors::*} is set:", "\tloop {_errors::*}: #If there is something wrong, it will add the errors here", "\t\tsend loop-value", "#It will send a string in Skript default error format:", "<Error message>: <wrong expression> (TuSKe/evaluate.sk, line <line of code>, '<whole line>')", "'TuSKe/evaluate.sk' is a fictitious file, it doesn't exist."})
@Since(value="1.7.5")
public class EffEvaluate
extends Effect {
    private Config currentScript;
    private Variable results;
    private Expression<String> varStr;
    private String str;

    protected void execute(Event event) {
        String code = this.str != null ? this.str : StringUtils.join((Object[])this.varStr.getArray(event), (String)"\n");
        EffEvaluate.evaluate(code, event, this.results, this.str != null, this.currentScript);
    }

    public String toString(Event event, boolean b) {
        return "evaluate inline";
    }

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (expr[0] != null) {
            if (expr[0] instanceof Variable && ((Variable)expr[0]).isList()) {
                this.results = (Variable)expr[0];
            } else {
                Skript.error((String)"The parameter needs to be a variable list.");
                return false;
            }
        }
        if (expr[1] == null) {
            this.str = ((MatchResult)parseResult.regexes.get(0)).group(0);
        } else {
            this.varStr = expr[1];
        }
        this.currentScript = ScriptLoader.currentScript;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evaluate(String code, Event e, Variable results, boolean parseString, Config currentScript) {
        if (code != null && !code.isEmpty()) {
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                if (parseString) {
                    ScriptLoader.currentScript = currentScript;
                    VariableString vs = VariableString.newInstance((String)code.replaceAll("\"", "\"\""));
                    if (vs != null) {
                        code = vs.getSingle(e);
                    }
                }
                code = code.replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t");
                Config c = new Config(code, "TuSKe/evaluate.sk", true, false, ":");
                ReflectionUtils.setField(c.getClass(), c, "file", new File("TuSKe/evaluate.sk"));
                ScriptLoader.currentScript = c;
                ScriptLoader.setCurrentEvent((String)"evaluate effect", (Class[])new Class[]{e.getClass()});
                TriggerSection ts = new TriggerSection(c.getMainNode()){

                    protected TriggerItem walk(Event event) {
                        return this.walk(event, true);
                    }

                    public String toString(Event event, boolean b) {
                        return "evaluate effect";
                    }
                };
                ScriptLoader.deleteCurrentEvent();
                ScriptLoader.currentScript = null;
                EffEvaluate.setVariable(log, e, results);
                TriggerItem.walk((TriggerItem)ts, (Event)e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                log.stop();
            }
        }
    }

    public static void setVariable(RetainingLogHandler log, Event e, Variable results) {
        if (results != null) {
            int x = 1;
            String name = ((VariableString)ReflectionUtils.getField(Variable.class, results, "name")).getSingle(e).toLowerCase();
            String varName = name.substring(0, name.length() - 1);
            for (LogEntry lg : log.getErrors()) {
                Variables.setVariable((String)(varName + x++), (Object)lg.getMessage(), (Event)e, (boolean)results.isLocal());
            }
        }
    }

    static {
        Registry.newEffect(EffEvaluate.class, "evaluate[ logging [[the] error[s]] in %-objects%]: (%-strings%|<.+?>)");
    }
}

