/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static boolean hasClass(String clz) {
        try {
            Class.forName(clz);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Class<?> getClass(String clz) {
        try {
            return Class.forName(clz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clz, Class<?> ... parameters) {
        try {
            return clz.getConstructor(parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean hasMethod(Class<?> clz, String method, Class<?> ... parameters) {
        try {
            return ReflectionUtils.getMethod(clz, method, parameters) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Method getMethod(Class<?> clz, String method, Class<?> ... parameters) {
        try {
            return clz.getDeclaredMethod(method, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T invokeMethod(Class<?> clz, String method, Object instance, Class<T> ret, Object ... parameters) {
        try {
            Class[] parameterTypes = new Class[parameters.length];
            int x = 0;
            Object[] objectArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                parameterTypes[x++] = obj.getClass();
                ++n2;
            }
            Method m = clz.getDeclaredMethod(method, parameterTypes);
            return (T)m.invoke(instance, parameters);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clz) {
        try {
            return clz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... objects) {
        try {
            return constructor.newInstance(objects);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> boolean setField(Class<T> from, Object obj, String field, Object newValue) {
        try {
            Field f = from.getDeclaredField(field);
            f.setAccessible(true);
            f.set(obj, newValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static <T> T getField(Class<?> from, Object obj, String field) {
        try {
            Field f = from.getDeclaredField(field);
            f.setAccessible(true);
            return (T)f.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

