/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions;

import ch.njol.skript.command.Commands;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.HashMap;
import javax.annotation.Nullable;
import me.tuke.sktuke.util.CommandUtils;
import me.tuke.sktuke.util.ReflectionUtils;
import org.bukkit.event.Event;

@Name(value="All commands")
@Description(value={"Used to get all registered commands.", "New in 1.7.1: You can get only script commands if you need it."})
@Examples(value={"command /help [<text>]:", "\ttrigger:", "\tall commands doesn't contain arg", "\t\tsend \"Unknown command!\""})
@Since(value="1.6.9.7")
public class ExprAllCommand
extends SimpleExpression<String> {
    private boolean scriptsOnly = false;

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.scriptsOnly = arg3.expr.toLowerCase().contains("script");
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.scriptsOnly ? "all scripts command" : "all commands";
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.scriptsOnly) {
            HashMap cmds = (HashMap)ReflectionUtils.getField(Commands.class, null, "commands");
            if (cmds == null) {
                cmds = new HashMap();
            }
            return cmds.keySet().toArray(new String[cmds.size()]);
        }
        return CommandUtils.getCommandList();
    }
}

