/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static void minimize(Automaton a) {
        if (!a.isSingleton()) {
            switch (Automaton.minimization) {
                case 0: {
                    MinimizationOperations.minimizeHuffman(a);
                    break;
                }
                case 1: {
                    MinimizationOperations.minimizeBrzozowski(a);
                    break;
                }
                default: {
                    MinimizationOperations.minimizeHopcroft(a);
                }
            }
        }
        a.recomputeHashCode();
    }

    private static boolean statesAgree(Transition[][] transitions, boolean[][] mark, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1].max < t2[k2].min) {
                ++k1;
                continue;
            }
            if (t2[k2].max < t1[k1].min) {
                ++k2;
                continue;
            }
            int m1 = t1[k1].to.number;
            int m2 = t2[k2].to.number;
            if (m1 > m2) {
                int t = m1;
                m1 = m2;
                m2 = t;
            }
            if (mark[m1][m2]) {
                return false;
            }
            if (t1[k1].max < t2[k2].max) {
                ++k1;
                continue;
            }
            ++k2;
        }
        return true;
    }

    private static void addTriggers(Transition[][] transitions, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1].max < t2[k2].min) {
                ++k1;
                continue;
            }
            if (t2[k2].max < t1[k1].min) {
                ++k2;
                continue;
            }
            if (t1[k1].to != t2[k2].to) {
                int m1 = t1[k1].to.number;
                int m2 = t2[k2].to.number;
                if (m1 > m2) {
                    int t = m1;
                    m1 = m2;
                    m2 = t;
                }
                if (triggers.get(m1).get(m2) == null) {
                    triggers.get(m1).set(m2, new HashSet());
                }
                triggers.get(m1).get(m2).add(new IntPair(n1, n2));
            }
            if (t1[k1].max < t2[k2].max) {
                ++k1;
                continue;
            }
            ++k2;
        }
    }

    private static void markPair(boolean[][] mark, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        mark[n1][n2] = true;
        if (triggers.get(n1).get(n2) != null) {
            for (IntPair p : triggers.get(n1).get(n2)) {
                int m1 = p.n1;
                int m2 = p.n2;
                if (m1 > m2) {
                    int t = m1;
                    m1 = m2;
                    m2 = t;
                }
                if (mark[m1][m2]) continue;
                MinimizationOperations.markPair(mark, triggers, m1, m2);
            }
        }
    }

    private static <T> void initialize(ArrayList<T> list, int size) {
        int i = 0;
        while (i < size) {
            list.add(null);
            ++i;
        }
    }

    public static void minimizeHuffman(Automaton a) {
        a.determinize();
        a.totalize();
        Set<State> ss = a.getStates();
        Transition[][] transitions = new Transition[ss.size()][];
        State[] states = ss.toArray(new State[ss.size()]);
        boolean[][] mark = new boolean[states.length][states.length];
        ArrayList<ArrayList<HashSet<IntPair>>> triggers = new ArrayList<ArrayList<HashSet<IntPair>>>();
        int n1 = 0;
        while (n1 < states.length) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, states.length);
            triggers.add(v);
            ++n1;
        }
        n1 = 0;
        while (n1 < states.length) {
            states[n1].number = n1;
            transitions[n1] = states[n1].getSortedTransitionArray(false);
            int n2 = n1 + 1;
            while (n2 < states.length) {
                if (states[n1].accept != states[n2].accept) {
                    mark[n1][n2] = true;
                }
                ++n2;
            }
            ++n1;
        }
        n1 = 0;
        while (n1 < states.length) {
            int n2 = n1 + 1;
            while (n2 < states.length) {
                if (!mark[n1][n2]) {
                    if (MinimizationOperations.statesAgree(transitions, mark, n1, n2)) {
                        MinimizationOperations.addTriggers(transitions, triggers, n1, n2);
                    } else {
                        MinimizationOperations.markPair(mark, triggers, n1, n2);
                    }
                }
                ++n2;
            }
            ++n1;
        }
        int numclasses = 0;
        int n = 0;
        while (n < states.length) {
            states[n].number = -1;
            ++n;
        }
        int n12 = 0;
        while (n12 < states.length) {
            if (states[n12].number == -1) {
                states[n12].number = numclasses;
                int n2 = n12 + 1;
                while (n2 < states.length) {
                    if (!mark[n12][n2]) {
                        states[n2].number = numclasses;
                    }
                    ++n2;
                }
                ++numclasses;
            }
            ++n12;
        }
        State[] newstates = new State[numclasses];
        int n2 = 0;
        while (n2 < numclasses) {
            newstates[n2] = new State();
            ++n2;
        }
        n2 = 0;
        while (n2 < states.length) {
            newstates[states[n2].number].number = n2;
            if (states[n2] == a.initial) {
                a.initial = newstates[states[n2].number];
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < numclasses) {
            State s = newstates[n2];
            s.accept = states[s.number].accept;
            for (Transition t : states[s.number].transitions) {
                s.transitions.add(new Transition(t.min, t.max, newstates[t.to.number]));
            }
            ++n2;
        }
        a.removeDeadTransitions();
    }

    public static void minimizeBrzozowski(Automaton a) {
        if (a.isSingleton()) {
            return;
        }
        BasicOperations.determinize(a, SpecialOperations.reverse(a));
        BasicOperations.determinize(a, SpecialOperations.reverse(a));
    }

    public static void minimizeHopcroft(Automaton a) {
        a.determinize();
        Set<Transition> tr = a.initial.getTransitions();
        if (tr.size() == 1) {
            Transition t = tr.iterator().next();
            if (t.to == a.initial && t.min == '\u0000' && t.max == '\uffff') {
                return;
            }
        }
        a.totalize();
        Set<State> ss = a.getStates();
        State[] states = new State[ss.size()];
        int number = 0;
        Iterator<State> iterator = ss.iterator();
        while (iterator.hasNext()) {
            State q;
            states[number] = q = iterator.next();
            q.number = number++;
        }
        char[] sigma = a.getStartPoints();
        ArrayList reverse = new ArrayList();
        int q = 0;
        while (q < states.length) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, sigma.length);
            reverse.add(v);
            ++q;
        }
        boolean[][] reverse_nonempty = new boolean[states.length][sigma.length];
        ArrayList partition = new ArrayList();
        MinimizationOperations.initialize(partition, states.length);
        int[] block = new int[states.length];
        StateList[][] active = new StateList[states.length][sigma.length];
        StateListNode[][] active2 = new StateListNode[states.length][sigma.length];
        LinkedList<IntPair> pending = new LinkedList<IntPair>();
        boolean[][] pending2 = new boolean[sigma.length][states.length];
        ArrayList<State> split = new ArrayList<State>();
        boolean[] split2 = new boolean[states.length];
        ArrayList<Integer> refine = new ArrayList<Integer>();
        boolean[] refine2 = new boolean[states.length];
        ArrayList splitblock = new ArrayList();
        MinimizationOperations.initialize(splitblock, states.length);
        int q2 = 0;
        while (q2 < states.length) {
            splitblock.set(q2, new ArrayList());
            partition.set(q2, new LinkedList());
            int x = 0;
            while (x < sigma.length) {
                ((ArrayList)reverse.get(q2)).set(x, new LinkedList());
                active[q2][x] = new StateList();
                ++x;
            }
            ++q2;
        }
        q2 = 0;
        while (q2 < states.length) {
            State qq = states[q2];
            int j = qq.accept ? 0 : 1;
            ((LinkedList)partition.get(j)).add(qq);
            block[qq.number] = j;
            int x = 0;
            while (x < sigma.length) {
                char y = sigma[x];
                State p = qq.step(y);
                ((LinkedList)((ArrayList)reverse.get(p.number)).get(x)).add(qq);
                reverse_nonempty[p.number][x] = true;
                ++x;
            }
            ++q2;
        }
        int j = 0;
        while (j <= 1) {
            int x = 0;
            while (x < sigma.length) {
                for (State qq : (LinkedList)partition.get(j)) {
                    if (!reverse_nonempty[qq.number][x]) continue;
                    active2[qq.number][x] = active[j][x].add(qq);
                }
                ++x;
            }
            ++j;
        }
        int x = 0;
        while (x < sigma.length) {
            int a0 = active[0][x].size;
            int a1 = active[1][x].size;
            int j2 = a0 <= a1 ? 0 : 1;
            pending.add(new IntPair(j2, x));
            pending2[x][j2] = true;
            ++x;
        }
        int k = 2;
        while (!pending.isEmpty()) {
            IntPair ip = (IntPair)pending.removeFirst();
            int p = ip.n1;
            int x2 = ip.n2;
            pending2[x2][p] = false;
            StateListNode m = active[p][x2].first;
            while (m != null) {
                for (State s : (LinkedList)((ArrayList)reverse.get(m.q.number)).get(x2)) {
                    if (split2[s.number]) continue;
                    split2[s.number] = true;
                    split.add(s);
                    int j3 = block[s.number];
                    ((ArrayList)splitblock.get(j3)).add(s);
                    if (refine2[j3]) continue;
                    refine2[j3] = true;
                    refine.add(j3);
                }
                m = m.next;
            }
            Iterator<Object> iterator2 = refine.iterator();
            while (iterator2.hasNext()) {
                int j4 = (Integer)iterator2.next();
                if (((ArrayList)splitblock.get(j4)).size() < ((LinkedList)partition.get(j4)).size()) {
                    LinkedList b1 = (LinkedList)partition.get(j4);
                    LinkedList b2 = (LinkedList)partition.get(k);
                    for (State s : (ArrayList)splitblock.get(j4)) {
                        b1.remove(s);
                        b2.add(s);
                        block[s.number] = k;
                        int c = 0;
                        while (c < sigma.length) {
                            StateListNode sn = active2[s.number][c];
                            if (sn != null && sn.sl == active[j4][c]) {
                                sn.remove();
                                active2[s.number][c] = active[k][c].add(s);
                            }
                            ++c;
                        }
                    }
                    int c = 0;
                    while (c < sigma.length) {
                        int aj = active[j4][c].size;
                        int ak = active[k][c].size;
                        if (!pending2[c][j4] && aj > 0 && aj <= ak) {
                            pending2[c][j4] = true;
                            pending.add(new IntPair(j4, c));
                        } else {
                            pending2[c][k] = true;
                            pending.add(new IntPair(k, c));
                        }
                        ++c;
                    }
                    ++k;
                }
                for (State s : (ArrayList)splitblock.get(j4)) {
                    split2[s.number] = false;
                }
                refine2[j4] = false;
                ((ArrayList)splitblock.get(j4)).clear();
            }
            split.clear();
            refine.clear();
        }
        State[] newstates = new State[k];
        int n = 0;
        while (n < newstates.length) {
            State s;
            newstates[n] = s = new State();
            for (State q3 : (LinkedList)partition.get(n)) {
                if (q3 == a.initial) {
                    a.initial = s;
                }
                s.accept = q3.accept;
                s.number = q3.number;
                q3.number = n;
            }
            ++n;
        }
        n = 0;
        while (n < newstates.length) {
            State s = newstates[n];
            s.accept = states[s.number].accept;
            for (Transition t : states[s.number].transitions) {
                s.transitions.add(new Transition(t.min, t.max, newstates[t.to.number]));
            }
            ++n;
        }
        a.removeDeadTransitions();
    }

    static class IntPair {
        int n1;
        int n2;

        IntPair(int n1, int n2) {
            this.n1 = n1;
            this.n2 = n2;
        }
    }

    static class StateList {
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(State q) {
            return new StateListNode(q, this);
        }
    }

    static class StateListNode {
        State q;
        StateListNode next;
        StateListNode prev;
        StateList sl;

        StateListNode(State q, StateList sl) {
            this.q = q;
            this.sl = sl;
            if (sl.size++ == 0) {
                sl.first = sl.last = this;
            } else {
                sl.last.next = this;
                this.prev = sl.last;
                sl.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }
}

