/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.Datatypes;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.StringUnionOperations;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public final class BasicAutomata {
    private BasicAutomata() {
    }

    public static Automaton makeEmpty() {
        State s;
        Automaton a = new Automaton();
        a.initial = s = new State();
        a.deterministic = true;
        return a;
    }

    public static Automaton makeEmptyString() {
        Automaton a = new Automaton();
        a.singleton = "";
        a.deterministic = true;
        return a;
    }

    public static Automaton makeAnyString() {
        State s;
        Automaton a = new Automaton();
        a.initial = s = new State();
        s.accept = true;
        s.transitions.add(new Transition('\u0000', '\uffff', s));
        a.deterministic = true;
        return a;
    }

    public static Automaton makeAnyChar() {
        return BasicAutomata.makeCharRange('\u0000', '\uffff');
    }

    public static Automaton makeChar(char c) {
        Automaton a = new Automaton();
        a.singleton = Character.toString(c);
        a.deterministic = true;
        return a;
    }

    public static Automaton makeCharRange(char min, char max) {
        if (min == max) {
            return BasicAutomata.makeChar(min);
        }
        Automaton a = new Automaton();
        State s1 = new State();
        State s2 = new State();
        a.initial = s1;
        s2.accept = true;
        if (min <= max) {
            s1.transitions.add(new Transition(min, max, s2));
        }
        a.deterministic = true;
        return a;
    }

    public static Automaton makeCharSet(String set) {
        if (set.length() == 1) {
            return BasicAutomata.makeChar(set.charAt(0));
        }
        Automaton a = new Automaton();
        State s1 = new State();
        State s2 = new State();
        a.initial = s1;
        s2.accept = true;
        int i = 0;
        while (i < set.length()) {
            s1.transitions.add(new Transition(set.charAt(i), s2));
            ++i;
        }
        a.deterministic = true;
        a.reduce();
        return a;
    }

    private static State anyOfRightLength(String x, int n) {
        State s = new State();
        if (x.length() == n) {
            s.setAccept(true);
        } else {
            s.addTransition(new Transition('0', '9', BasicAutomata.anyOfRightLength(x, n + 1)));
        }
        return s;
    }

    private static State atLeast(String x, int n, Collection<State> initials, boolean zeros) {
        State s = new State();
        if (x.length() == n) {
            s.setAccept(true);
        } else {
            if (zeros) {
                initials.add(s);
            }
            char c = x.charAt(n);
            s.addTransition(new Transition(c, BasicAutomata.atLeast(x, n + 1, initials, zeros && c == '0')));
            if (c < '9') {
                s.addTransition(new Transition((char)(c + '\u0001'), '9', BasicAutomata.anyOfRightLength(x, n + 1)));
            }
        }
        return s;
    }

    private static State atMost(String x, int n) {
        State s = new State();
        if (x.length() == n) {
            s.setAccept(true);
        } else {
            char c = x.charAt(n);
            s.addTransition(new Transition(c, BasicAutomata.atMost(x, (char)n + '\u0001')));
            if (c > '0') {
                s.addTransition(new Transition('0', (char)(c - '\u0001'), BasicAutomata.anyOfRightLength(x, n + 1)));
            }
        }
        return s;
    }

    private static State between(String x, String y, int n, Collection<State> initials, boolean zeros) {
        State s = new State();
        if (x.length() == n) {
            s.setAccept(true);
        } else {
            char cy;
            char cx;
            if (zeros) {
                initials.add(s);
            }
            if ((cx = x.charAt(n)) == (cy = y.charAt(n))) {
                s.addTransition(new Transition(cx, BasicAutomata.between(x, y, n + 1, initials, zeros && cx == '0')));
            } else {
                s.addTransition(new Transition(cx, BasicAutomata.atLeast(x, n + 1, initials, zeros && cx == '0')));
                s.addTransition(new Transition(cy, BasicAutomata.atMost(y, n + 1)));
                if (cx + '\u0001' < cy) {
                    s.addTransition(new Transition((char)(cx + '\u0001'), (char)(cy - '\u0001'), BasicAutomata.anyOfRightLength(x, n + 1)));
                }
            }
        }
        return s;
    }

    public static Automaton makeInterval(int min, int max, int digits) throws IllegalArgumentException {
        Automaton a = new Automaton();
        String x = Integer.toString(min);
        String y = Integer.toString(max);
        if (min > max || digits > 0 && y.length() > digits) {
            throw new IllegalArgumentException();
        }
        int d = digits > 0 ? digits : y.length();
        StringBuilder bx = new StringBuilder();
        int i = x.length();
        while (i < d) {
            bx.append('0');
            ++i;
        }
        bx.append(x);
        x = bx.toString();
        StringBuilder by = new StringBuilder();
        int i2 = y.length();
        while (i2 < d) {
            by.append('0');
            ++i2;
        }
        by.append(y);
        y = by.toString();
        ArrayList<State> initials = new ArrayList<State>();
        a.initial = BasicAutomata.between(x, y, 0, initials, digits <= 0);
        if (digits <= 0) {
            ArrayList<StatePair> pairs = new ArrayList<StatePair>();
            for (State p : initials) {
                if (a.initial == p) continue;
                pairs.add(new StatePair(a.initial, p));
            }
            a.addEpsilons(pairs);
            a.initial.addTransition(new Transition('0', a.initial));
            a.deterministic = false;
        } else {
            a.deterministic = true;
        }
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton makeString(String s) {
        Automaton a = new Automaton();
        a.singleton = s;
        a.deterministic = true;
        return a;
    }

    public static Automaton makeStringUnion(CharSequence ... strings) {
        if (strings.length == 0) {
            return BasicAutomata.makeEmpty();
        }
        Arrays.sort(strings, StringUnionOperations.LEXICOGRAPHIC_ORDER);
        Automaton a = new Automaton();
        a.setInitialState(StringUnionOperations.build(strings));
        a.setDeterministic(true);
        a.reduce();
        a.recomputeHashCode();
        return a;
    }

    public static Automaton makeMaxInteger(String n) {
        int i = 0;
        while (i < n.length() && n.charAt(i) == '0') {
            ++i;
        }
        StringBuilder b = new StringBuilder();
        b.append("0*(0|");
        if (i < n.length()) {
            b.append("[0-9]{1," + (n.length() - i - 1) + "}|");
        }
        BasicAutomata.maxInteger(n.substring(i), 0, b);
        b.append(")");
        return Automaton.minimize(new RegExp(b.toString()).toAutomaton());
    }

    private static void maxInteger(String n, int i, StringBuilder b) {
        b.append('(');
        if (i < n.length()) {
            char c = n.charAt(i);
            if (c != '0') {
                b.append("[0-" + (char)(c - '\u0001') + "][0-9]{" + (n.length() - i - 1) + "}|");
            }
            b.append(c);
            BasicAutomata.maxInteger(n, i + 1, b);
        }
        b.append(')');
    }

    public static Automaton makeMinInteger(String n) {
        int i = 0;
        while (i + 1 < n.length() && n.charAt(i) == '0') {
            ++i;
        }
        StringBuilder b = new StringBuilder();
        b.append("0*");
        BasicAutomata.minInteger(n.substring(i), 0, b);
        b.append("[0-9]*");
        return Automaton.minimize(new RegExp(b.toString()).toAutomaton());
    }

    private static void minInteger(String n, int i, StringBuilder b) {
        b.append('(');
        if (i < n.length()) {
            char c = n.charAt(i);
            if (c != '9') {
                b.append("[" + (char)(c + '\u0001') + "-9][0-9]{" + (n.length() - i - 1) + "}|");
            }
            b.append(c);
            BasicAutomata.minInteger(n, i + 1, b);
        }
        b.append(')');
    }

    public static Automaton makeTotalDigits(int i) {
        return Automaton.minimize(new RegExp("[ \t\n\r]*[-+]?0*([0-9]{0," + i + "}|((([0-9]\\.*){0," + i + "})&@\\.@)0*)[ \t\n\r]*").toAutomaton());
    }

    public static Automaton makeFractionDigits(int i) {
        return Automaton.minimize(new RegExp("[ \t\n\r]*[-+]?[0-9]+(\\.[0-9]{0," + i + "}0*)?[ \t\n\r]*").toAutomaton());
    }

    public static Automaton makeIntegerValue(String value) {
        boolean minus = false;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '-') {
                minus = true;
            }
            if (c >= '1' && c <= '9') break;
            ++i;
        }
        StringBuilder b = new StringBuilder();
        b.append(value.substring(i));
        if (b.length() == 0) {
            b.append("0");
        }
        Automaton s = minus ? Automaton.makeChar('-') : Automaton.makeChar('+').optional();
        Automaton ws = Datatypes.getWhitespaceAutomaton();
        return Automaton.minimize(ws.concatenate(s.concatenate(Automaton.makeChar('0').repeat()).concatenate(Automaton.makeString(b.toString()))).concatenate(ws));
    }

    public static Automaton makeDecimalValue(String value) {
        boolean minus = false;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '-') {
                minus = true;
            }
            if (c >= '1' && c <= '9' || c == '.') break;
            ++i;
        }
        StringBuilder b1 = new StringBuilder();
        StringBuilder b2 = new StringBuilder();
        int p = value.indexOf(46, i);
        if (p == -1) {
            b1.append(value.substring(i));
        } else {
            b1.append(value.substring(i, p));
            i = value.length() - 1;
            while (i > p) {
                char c = value.charAt(i);
                if (c >= '1' && c <= '9') break;
                --i;
            }
            b2.append(value.substring(p + 1, i + 1));
        }
        if (b1.length() == 0) {
            b1.append("0");
        }
        Automaton s = minus ? Automaton.makeChar('-') : Automaton.makeChar('+').optional();
        Automaton d = b2.length() == 0 ? Automaton.makeChar('.').concatenate(Automaton.makeChar('0').repeat(1)).optional() : Automaton.makeChar('.').concatenate(Automaton.makeString(b2.toString())).concatenate(Automaton.makeChar('0').repeat());
        Automaton ws = Datatypes.getWhitespaceAutomaton();
        return Automaton.minimize(ws.concatenate(s.concatenate(Automaton.makeChar('0').repeat()).concatenate(Automaton.makeString(b1.toString())).concatenate(d)).concatenate(ws));
    }

    /*
     * Unable to fully structure code
     */
    public static Automaton makeStringMatcher(String s) {
        a = new Automaton();
        states = new State[s.length() + 1];
        states[0] = a.initial;
        i = 0;
        while (i < s.length()) {
            states[i + 1] = new State();
            ++i;
        }
        f = states[s.length()];
        f.accept = true;
        f.transitions.add(new Transition('\u0000', '\uffff', f));
        i = 0;
        while (i < s.length()) {
            done = new HashSet<Character>();
            c = s.charAt(i);
            states[i].transitions.add(new Transition(c, states[i + 1]));
            done.add(Character.valueOf(c));
            j = i;
            while (j >= 1) {
                d = s.charAt(j - 1);
                if (!done.contains(Character.valueOf(d)) && s.substring(0, j - 1).equals(s.substring(i - j + 1, i))) {
                    states[i].transitions.add(new Transition(d, states[j]));
                    done.add(Character.valueOf(d));
                }
                --j;
            }
            da = new char[done.size()];
            h = 0;
            var10_13 = done.iterator();
            while (var10_13.hasNext()) {
                w = ((Character)var10_13.next()).charValue();
                da[h++] = w;
            }
            Arrays.sort(da);
            from = 0;
            k = 0;
            ** GOTO lbl54
            {
                ++k;
                ++from;
                do {
                    if (k < da.length && da[k] == from) continue block4;
                    if (from > 65535) continue;
                    to = 65535;
                    if (k < da.length) {
                        to = da[k] - '\u0001';
                        ++k;
                    }
                    states[i].transitions.add(new Transition((char)from, (char)to, states[0]));
                    from = to + 2;
lbl54:
                    // 3 sources

                } while (from <= 65535);
            }
            ++i;
        }
        a.deterministic = true;
        return a;
    }
}

